/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.CustomButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MultiStateToggleButton
extends CustomButton {
    public static final int MIN_STATES = 2;
    public static final int MAX_STATES = 9;
    public static final int DEFAULT_WIDTH = 18;
    public static final int DEFAULT_HEIGHT = 18;
    public static final int DEFAULT_SPRITE_WIDTH = 12;
    public static final int DEFAULT_SPRITE_HEIGHT = 12;
    public static final int DEFAULT_SPRITE_X = 3;
    public static final int DEFAULT_SPRITE_Y = 3;
    public static final ResourceLocation DEFAULT_SPRITE = Constants.TEXTURE_CONFIGURATION;
    private final ToggleState[] states;
    private final ResourceLocation spriteTexture;
    private final int spriteX;
    private final int spriteY;
    private final int spriteWidth;
    private final int spriteHeight;
    private final OnStateChange onStateChange;
    private int currentStateIndex;
    private boolean renderBackground = true;

    public MultiStateToggleButton(int left, int top, ToggleState[] states, int initialStateIndex, OnStateChange onStateChange) {
        this(left, top, 18, 18, DEFAULT_SPRITE, 3, 3, 12, 12, states, initialStateIndex, onStateChange);
    }

    public MultiStateToggleButton(int left, int top, int width, int height, ToggleState[] states, int initialStateIndex, OnStateChange onStateChange) {
        this(left, top, width, height, DEFAULT_SPRITE, 3, height <= 16 ? 2 : 3, 12, 12, states, initialStateIndex, onStateChange);
    }

    public MultiStateToggleButton(int left, int top, int width, int height, ResourceLocation spriteTexture, int spriteX, int spriteY, int spriteWidth, int spriteHeight, ToggleState[] states, int initialStateIndex, OnStateChange onStateChange) {
        super(left, top, width, height, (Component)Component.empty(), button -> {});
        if (states.length < 2 || states.length > 9) {
            throw new IllegalArgumentException("MultiStateToggleButton requires between 2 and 9 states, but got " + states.length);
        }
        if (initialStateIndex < 0 || initialStateIndex >= states.length) {
            throw new IllegalArgumentException("Initial state index " + initialStateIndex + " is out of bounds for " + states.length + " states");
        }
        this.states = states;
        this.currentStateIndex = initialStateIndex;
        this.onStateChange = onStateChange;
        this.spriteTexture = spriteTexture;
        this.spriteX = spriteX;
        this.spriteY = spriteY;
        this.spriteWidth = spriteWidth;
        this.spriteHeight = spriteHeight;
        this.updateTooltip();
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        if (!this.visible) {
            return false;
        }
        if (this.isValidClickButton(mouseButtonEvent.buttonInfo()) && this.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y())) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.cycleToNextState();
            this.onClick(mouseButtonEvent, doubleClick);
            return true;
        }
        return false;
    }

    @Override
    public void renderButton(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.renderBackground) {
            super.renderButton(guiGraphics, mouseX, mouseY, partialTicks);
        }
        ToggleState currentState = this.states[this.currentStateIndex];
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.spriteTexture, this.getX() + this.spriteX, this.getY() + this.spriteY, (float)currentState.spriteOffsetX(), this.active ? (float)currentState.spriteOffsetY() : (float)(currentState.spriteOffsetY() + this.spriteHeight), this.spriteWidth, this.spriteHeight, 256, 256);
    }

    private void cycleToNextState() {
        this.currentStateIndex = (this.currentStateIndex + 1) % this.states.length;
        this.updateTooltip();
        if (this.onStateChange != null) {
            this.onStateChange.onStateChange(this, this.currentStateIndex);
        }
    }

    private void updateTooltip() {
        ToggleState currentState = this.states[this.currentStateIndex];
        if (currentState.tooltip() != null) {
            this.setTooltip(Tooltip.create((Component)currentState.tooltip()));
        }
    }

    public int getCurrentStateIndex() {
        return this.currentStateIndex;
    }

    public void setCurrentStateIndex(int stateIndex) {
        if (stateIndex >= 0 && stateIndex < this.states.length) {
            this.currentStateIndex = stateIndex;
            this.updateTooltip();
        }
    }

    public ToggleState getCurrentState() {
        return this.states[this.currentStateIndex];
    }

    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    public boolean isMouseOver(double x, double y) {
        return this.visible && x >= (double)this.getX() && y >= (double)this.getY() && x < (double)(this.getX() + this.width) && y < (double)(this.getY() + this.height);
    }

    public record ToggleState(int spriteOffsetX, int spriteOffsetY, Component tooltip) {
    }

    @FunctionalInterface
    public static interface OnStateChange {
        public void onStateChange(MultiStateToggleButton var1, int var2);
    }
}

