/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class UpDownButton
extends AbstractWidget {
    protected final OnUp onUp;
    protected final OnDown onDown;
    private final Button upButton;
    private final Button downButton;

    public UpDownButton(int left, int top, int width, int height, OnUp onUp, OnDown onDown) {
        super(left, top, width, height, (Component)TextComponent.getBlankText());
        this.onUp = onUp;
        this.onDown = onDown;
        int singleButtonHeight = height / 2;
        this.upButton = new SpriteButton(left, top, width, singleButtonHeight, Constants.TEXTURE_CONFIGURATION, 5, 2, 93, 59, 9, 6, button -> this.onUp.onUp(this));
        this.downButton = new SpriteButton(left, top + singleButtonHeight, width, singleButtonHeight, Constants.TEXTURE_CONFIGURATION, 5, 2, 93, 84, 9, 6, button -> this.onDown.onDown(this));
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.upButton != null) {
            this.upButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.downButton != null) {
            this.downButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        if (this.upButton != null && this.upButton.mouseClicked(mouseButtonEvent, doubleClick)) {
            return true;
        }
        return this.downButton != null && this.downButton.mouseClicked(mouseButtonEvent, doubleClick);
    }

    public void setY(int y) {
        super.setY(y);
        if (this.upButton != null) {
            this.upButton.setY(y);
        }
        if (this.downButton != null) {
            this.downButton.setY(y + this.height / 2);
        }
    }

    public void enableUpButton(boolean enable) {
        this.upButton.active = enable;
        this.upButton.visible = enable;
    }

    public void enableDownButton(boolean enable) {
        this.downButton.active = enable;
        this.downButton.visible = enable;
    }

    public static interface OnUp {
        public void onUp(UpDownButton var1);
    }

    public static interface OnDown {
        public void onDown(UpDownButton var1);
    }
}

