/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.data.npc.UserDefinedConfiguration;
import de.markusbordihn.easynpc.data.npc.UserDefinedConfigurationManager;
import de.markusbordihn.easynpc.entity.UserDefinedEntityType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDefinedEntityRegistry {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<UserDefinedEntityType, EntityType<?>> registeredEntityTypes = new ConcurrentHashMap();
    private static final Set<UserDefinedEntityType> availableEntityTypes = ConcurrentHashMap.newKeySet();
    private static boolean initialized = false;

    private UserDefinedEntityRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        if (initialized) {
            log.debug("User-defined entity registry already initialized");
            return;
        }
        log.info("Initializing user-defined NPC registry...");
        try {
            Map<String, UserDefinedConfiguration> configurations = UserDefinedConfigurationManager.getUserDefinedConfigurations();
            if (configurations.isEmpty()) {
                log.info("No user-defined NPCs found in configuration");
                return;
            }
            int successfulRegistrations = 0;
            for (Map.Entry<String, UserDefinedConfiguration> entry : configurations.entrySet()) {
                String npcId = entry.getKey();
                UserDefinedConfiguration configuration = entry.getValue();
                if (UserDefinedEntityRegistry.registerUserDefinedNPC(configuration)) {
                    ++successfulRegistrations;
                    log.debug("Successfully registered user-defined NPC: {}", (Object)npcId);
                    continue;
                }
                log.warn("Failed to register user-defined NPC: {}", (Object)npcId);
            }
            log.info("Successfully registered {} out of {} user-defined NPCs", (Object)successfulRegistrations, (Object)configurations.size());
        }
        catch (Exception e) {
            log.error("Failed to initialize user-defined entity registry: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            initialized = true;
        }
    }

    private static boolean registerUserDefinedNPC(UserDefinedConfiguration configuration) {
        if (!configuration.isValid()) {
            log.error("Invalid configuration for NPC: {}", (Object)configuration.id());
            return false;
        }
        try {
            UserDefinedEntityType entityType = UserDefinedEntityRegistry.createEntityType(configuration);
            availableEntityTypes.add(entityType);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to register user-defined NPC {}: {}", (Object)configuration.id(), (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private static UserDefinedEntityType createEntityType(UserDefinedConfiguration configuration) {
        return new UserDefinedEntityType(configuration.id(), configuration.baseEntityType(), configuration.width(), configuration.height());
    }

    public static Set<UserDefinedEntityType> getAvailableEntityTypes() {
        if (!initialized) {
            UserDefinedEntityRegistry.initialize();
        }
        return Collections.unmodifiableSet(availableEntityTypes);
    }

    public static EntityType<?> getRegisteredEntityType(UserDefinedEntityType userDefinedType) {
        return registeredEntityTypes.get(userDefinedType);
    }

    public static void registerEntityType(UserDefinedEntityType userDefinedType, EntityType<?> entityType) {
        if (userDefinedType == null || entityType == null) {
            log.error("Cannot register null entity type or user-defined type");
            return;
        }
        registeredEntityTypes.put(userDefinedType, entityType);
        log.debug("Registered entity type for user-defined NPC: {}", (Object)userDefinedType.getId());
    }

    public static boolean isRegistered(UserDefinedEntityType userDefinedType) {
        return registeredEntityTypes.containsKey(userDefinedType);
    }

    public static int getRegisteredCount() {
        return registeredEntityTypes.size();
    }

    public static int getAvailableCount() {
        return availableEntityTypes.size();
    }

    public static void reload() {
        log.info("Reloading user-defined entity registry...");
        availableEntityTypes.clear();
        registeredEntityTypes.clear();
        initialized = false;
        UserDefinedEntityRegistry.initialize();
    }

    static {
        UserDefinedEntityRegistry.initialize();
    }
}

