/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface SkinDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_SKIN_DATA_TAG = "SkinData";

    public static void registerSyncedSkinData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Skin Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.SKIN_DATA, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.SKIN_DATA_ENTRY));
    }

    default public int getEntitySkinScaling() {
        return 30;
    }

    default public String getSkinURL() {
        return this.getSkinDataEntry().url();
    }

    default public UUID getSkinUUID() {
        return this.getSkinDataEntry().uuid();
    }

    default public SkinType getSkinType() {
        return this.getSkinDataEntry().type();
    }

    default public SkinModel getSkinModel() {
        return SkinModel.HUMANOID;
    }

    default public SkinDataEntry getSkinDataEntry() {
        return (SkinDataEntry)this.getSynchedEntityData(SynchedDataIndex.SKIN_DATA);
    }

    default public void setSkinDataEntry(SkinDataEntry skinDataEntry) {
        this.setSynchedEntityData(SynchedDataIndex.SKIN_DATA, skinDataEntry);
    }

    default public void defineSynchedSkinData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.SKIN_DATA, new SkinDataEntry());
    }

    default public void addAdditionalSkinData(ValueOutput valueOutput) {
        CompoundTag skinTag = new CompoundTag();
        this.getSkinDataEntry().write(skinTag);
        valueOutput.store(EASY_NPC_DATA_SKIN_DATA_TAG, CompoundTag.CODEC, (Object)skinTag);
    }

    default public void readAdditionalSkinData(ValueInput valueInput) {
        Optional compoundTagData = valueInput.read(EASY_NPC_DATA_SKIN_DATA_TAG, CompoundTag.CODEC);
        if (compoundTagData.isEmpty()) {
            log.warn("No skin data available for {}.", (Object)this);
            return;
        }
        CompoundTag skinTag = (CompoundTag)compoundTagData.get();
        SkinDataEntry skinDataEntry = new SkinDataEntry(skinTag);
        this.setSkinDataEntry(skinDataEntry);
    }
}

