/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttributeHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface BaseTickHandler<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final int BASE_TICK = 16;
    public static final int TRADING_BASE_TICK = Math.round(75.0f) - 10;
    public static final int ATTRIBUTE_BASE_TICK = Math.round(25.0f);

    default public void handleBaseTick() {
        this.getProfiler().push("npcBaseTick");
        TickerDataCapable tickerData = this.getEasyNPCTickerData();
        if (tickerData.checkAndIncreaseTicker(TickerType.BASE_TICK, 16)) {
            Entity entity = this.getEntity();
            if (tickerData.checkAndIncreaseTicker(TickerType.ATTRIBUTE_BASE_TICK, ATTRIBUTE_BASE_TICK)) {
                AttributeHandler attributeHandler = this.getEasyNPCAttributeHandler();
                attributeHandler.checkAttributeActions();
                tickerData.resetTicker(TickerType.ATTRIBUTE_BASE_TICK);
            }
            ActionHandler actionHandler = this.getEasyNPCActionHandler();
            actionHandler.checkDistanceActions();
            if (tickerData.checkAndIncreaseTicker(TickerType.TRADING_BASE_TICK, TRADING_BASE_TICK)) {
                TradingDataCapable tradingData = this.getEasyNPCTradingData();
                if (tradingData.hasTradingData()) {
                    actionHandler.checkTradingActions();
                }
                tickerData.resetTicker(TickerType.TRADING_BASE_TICK);
            }
            if (entity.isInLiquid() && this.getEasyNPCAttributeData().getEntityAttributes().getEnvironmentalAttributes().canBreatheUnderwater()) {
                entity.setAirSupply(300);
            }
            tickerData.resetTicker(TickerType.BASE_TICK);
        }
        this.getProfiler().pop();
    }
}

