/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.configuration.ConfigurationData;
import de.markusbordihn.easynpc.data.skin.variant.IronGolemSkinVariant;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.IronGolemRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IronGolemNPC
extends IronGolemRaw
implements StandardEasyNPC<IronGolemRaw> {
    public static final String ID = "iron_golem";

    public IronGolemNPC(EntityType<? extends IronGolem> entityType, Level level) {
        this(entityType, level, IronGolemSkinVariant.IRON_GOLEM);
    }

    public IronGolemNPC(EntityType<? extends IronGolem> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 15.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_SPEED, 4.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    @Override
    public int getEntityDialogScaling() {
        return 38;
    }

    @Override
    public int getEntitySkinScaling() {
        return 25;
    }

    @Override
    public ConfigurationData getConfigurationData() {
        return ConfigurationData.STANDARD;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addDefaultSound(SoundType.DAMAGE, SoundEvents.IRON_GOLEM_DAMAGE);
        soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.IRON_GOLEM_DEATH);
        soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.IRON_GOLEM_HURT);
        soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.IRON_GOLEM_STEP);
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void registerGoals() {
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

