/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.mixin.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.utils.ItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public class EasyNPCEntityRendererMixin<T extends Entity, S extends EntityRenderState> {
    @Inject(method={"shouldRender"}, at={@At(value="HEAD")}, cancellable=true)
    private void onShouldRender(T entity, Frustum frustum, double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof EasyNPC) {
            boolean isInvisible;
            double wandRange;
            double distanceSquared;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            boolean holdingNPCWand = ItemUtils.isPlayerHoldingEasyNPCWand((Player)player);
            if (holdingNPCWand && (distanceSquared = entity.distanceToSqr((Entity)player)) <= (wandRange = 32.0) * wandRange) {
                cir.setReturnValue((Object)true);
                return;
            }
            boolean bl = isInvisible = entity.isInvisible() || entity.isInvisibleTo((Player)player);
            if (isInvisible) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"getBlockLightLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockLightLevel(T entity, BlockPos blockPos, CallbackInfoReturnable<Integer> cir) {
        EasyNPC easyNPC;
        if (entity instanceof EasyNPC && (easyNPC = (EasyNPC)entity).getEasyNPCDisplayAttributeData() instanceof DisplayAttributeDataCapable) {
            cir.setReturnValue((Object)EasyNPCModel.getEntityLightLevel(easyNPC, easyNPC.getEasyNPCDisplayAttributeData(), blockPos));
        }
    }

    @Inject(method={"submitNameTag"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSubmitNameTag(S renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo ci) {
        EasyNPCRenderStateExtension renderStateExtension;
        if (renderState instanceof EasyNPCRenderStateExtension && !EasyNPCModel.renderEntityNameTag(renderStateExtension = (EasyNPCRenderStateExtension)renderState, poseStack)) {
            ci.cancel();
        }
    }
}

