/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.mixin.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCLivingEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public class EasyNPCLivingEntityRendererMixin {
    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;F)V"}, at={@At(value="TAIL")})
    private void injectEasyNpcUUID(LivingEntity livingEntity, LivingEntityRenderState renderState, float partialTicks, CallbackInfo ci) {
        if (livingEntity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)livingEntity;
            if (renderState instanceof EasyNPCRenderStateExtension) {
                EasyNPCRenderStateExtension renderStateExtension = (EasyNPCRenderStateExtension)renderState;
                renderStateExtension.setEasyNpcUUID(easyNPC.getEntityUUID());
                EasyNPCLivingEntityRenderer.extractAndCacheTexture(easyNPC, renderStateExtension, renderState, (LivingEntityRenderer)this);
            }
        }
    }

    @Inject(method={"submit(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="HEAD")})
    private void onRenderStart(LivingEntityRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo ci) {
        if (renderState instanceof EasyNPCRenderStateExtension) {
            EasyNPCLivingEntityRenderer.handleRenderStart(renderState, poseStack, null, 0);
        }
    }

    @Inject(method={"submit(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="TAIL")})
    private void onRenderEnd(LivingEntityRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo ci) {
        if (renderState instanceof EasyNPCRenderStateExtension) {
            EasyNPCLivingEntityRenderer.handleRenderEnd(renderState, poseStack, null, 0);
        }
    }

    @Inject(method={"scale"}, at={@At(value="HEAD")})
    private void onScale(LivingEntityRenderState renderState, PoseStack poseStack, CallbackInfo ci) {
        if (renderState instanceof EasyNPCRenderStateExtension) {
            EasyNPCLivingEntityRenderer.handleScale(renderState, poseStack);
        }
    }
}

