/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import de.markusbordihn.easynpc.entity.ModEntityTypeProvider;
import de.markusbordihn.easynpc.entity.ModNPCEntityType;
import de.markusbordihn.easynpc.entity.ModRawEntityType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TestCommand
extends Command {
    private TestCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"test").requires(commandSource -> commandSource.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn").then(((LiteralArgumentBuilder)Commands.literal((String)"raw_npc").executes(context -> TestCommand.spawnAllEntities((CommandSourceStack)context.getSource(), ModRawEntityType.class))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModRawEntityType type : ModRawEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModRawEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModRawEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((CommandSourceStack)context.getSource(), type);
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"standard_npc").executes(context -> TestCommand.spawnAllEntities((CommandSourceStack)context.getSource(), ModNPCEntityType.class))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModNPCEntityType type : ModNPCEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModNPCEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModNPCEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((CommandSourceStack)context.getSource(), type);
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"custom_npc").executes(context -> TestCommand.spawnAllEntities((CommandSourceStack)context.getSource(), ModCustomEntityType.class))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModCustomEntityType type : ModCustomEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModCustomEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModCustomEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((CommandSourceStack)context.getSource(), type);
        }))));
    }

    public static <T extends Enum<T>> int spawnAllEntities(CommandSourceStack source, Class<T> enumClass) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = player.level();
        BlockPos basePos = player.blockPosition().offset(0, 1, 0);
        int index = 0;
        for (Enum type : (Enum[])enumClass.getEnumConstants()) {
            int xOffset = index % 5 * 10;
            int zOffset = index / 5 * 10;
            BlockPos npcPos = basePos.offset(xOffset, 0, zOffset);
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(((ModEntityTypeProvider)((Object)type)).getResourceKey());
            TestCommand.spawnNpcInTestArea(level, npcPos, entityType);
            ++index;
        }
        source.sendSuccess(() -> Component.literal((String)("Spawned " + ((Enum[])enumClass.getEnumConstants()).length + " " + enumClass.getSimpleName() + "s for testing.")), false);
        return 1;
    }

    public static <T extends Enum<T>> int spawnSingleEntity(CommandSourceStack source, T type) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = player.level();
        BlockPos basePos = player.blockPosition().offset(0, 1, 0);
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(((ModEntityTypeProvider)((Object)type)).getResourceKey());
        TestCommand.spawnNpcInTestArea(level, basePos, entityType);
        source.sendSuccess(() -> Component.literal((String)("Spawned " + type.getClass().getSimpleName() + ": " + type.name())), false);
        return 1;
    }

    private static void spawnNpcInTestArea(ServerLevel level, BlockPos centerPos, EntityType<?> entityType) {
        int dz;
        int dx;
        int radius = 3;
        TestCommand.fillArea(level, centerPos.offset(-radius, -1, -radius), centerPos.offset(radius, 4, radius), Blocks.AIR.defaultBlockState());
        for (dx = -radius; dx <= radius; ++dx) {
            for (dz = -radius; dz <= radius; ++dz) {
                BlockPos floorPos = centerPos.offset(dx, -1, dz);
                if (Math.abs(dx) == radius && Math.abs(dz) == radius) {
                    level.setBlockAndUpdate(floorPos, Blocks.GLOWSTONE.defaultBlockState());
                    continue;
                }
                level.setBlockAndUpdate(floorPos, Blocks.QUARTZ_BLOCK.defaultBlockState());
            }
        }
        for (dx = -radius; dx <= radius; ++dx) {
            for (dz = -radius; dz <= radius; ++dz) {
                boolean isCorner;
                boolean isEdge = Math.abs(dx) == radius || Math.abs(dz) == radius;
                boolean bl = isCorner = Math.abs(dx) == radius && Math.abs(dz) == radius;
                if (!isEdge) continue;
                for (int dy = 0; dy < (isCorner ? 3 : 1); ++dy) {
                    BlockPos wallPos = centerPos.offset(dx, dy, dz);
                    level.setBlockAndUpdate(wallPos, Blocks.OAK_FENCE.defaultBlockState());
                }
            }
        }
        TestCommand.fillArea(level, centerPos.offset(-radius, 3, -radius), centerPos.offset(radius, 3, radius), Blocks.OAK_SLAB.defaultBlockState());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                BlockPos lowerSlabPos = centerPos.offset(dx, 3, dz);
                level.setBlockAndUpdate(lowerSlabPos, Blocks.OAK_PLANKS.defaultBlockState());
            }
        }
        BlockPos gatePos = centerPos.offset(0, 0, radius);
        level.setBlockAndUpdate(gatePos, (BlockState)Blocks.OAK_FENCE_GATE.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH));
        BlockPos signPos = centerPos.offset(0, 4, 0);
        level.setBlockAndUpdate(signPos, Blocks.OAK_SIGN.defaultBlockState());
        BlockEntity blockEntity = level.getBlockEntity(signPos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            sign.setText(new SignText().setMessage(0, (Component)Component.literal((String)"EntityType:")).setMessage(1, (Component)Component.literal((String)entityType.toShortString())), false);
            sign.setChanged();
        }
        entityType.spawn(level, null, null, centerPos, EntitySpawnReason.COMMAND, true, false);
    }

    private static void fillArea(ServerLevel level, BlockPos from, BlockPos to, BlockState blockState) {
        BlockPos.betweenClosedStream((BlockPos)from, (BlockPos)to).forEach(pos -> level.setBlockAndUpdate(pos.immutable(), blockState));
    }
}

