/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import de.markusbordihn.easynpc.data.scale.CustomScale;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class CompoundTagUtils {
    public static final String ID_PREFIX = "id_";
    public static final String X_TAG = "X";
    public static final String Y_TAG = "Y";
    public static final String Z_TAG = "Z";
    public static final String UUID_TAG = "UUID";

    private CompoundTagUtils() {
    }

    public static void writeUUID(CompoundTag compoundTag, UUID uuid) {
        CompoundTagUtils.writeUUID(compoundTag, UUID_TAG, uuid);
    }

    public static void writeUUID(CompoundTag compoundTag, String key, UUID uuid) {
        if (compoundTag == null || key == null || uuid == null) {
            return;
        }
        long mostSignificantBits = uuid.getMostSignificantBits();
        long leastSignificantBits = uuid.getLeastSignificantBits();
        int[] uuidArray = new int[]{(int)(mostSignificantBits >> 32), (int)mostSignificantBits, (int)(leastSignificantBits >> 32), (int)leastSignificantBits};
        compoundTag.put(key, (Tag)new IntArrayTag(uuidArray));
    }

    public static UUID readUUID(CompoundTag compoundTag) {
        return CompoundTagUtils.readUUID(compoundTag, UUID_TAG);
    }

    public static UUID readUUID(CompoundTag compoundTag, String key) {
        if (compoundTag == null || key == null || !compoundTag.contains(key)) {
            return null;
        }
        Tag tag = compoundTag.get(key);
        if (!(tag instanceof IntArrayTag)) {
            return null;
        }
        IntArrayTag intArrayTag = (IntArrayTag)tag;
        int[] uuidArray = intArrayTag.getAsIntArray();
        if (uuidArray.length != 4) {
            return null;
        }
        try {
            long mostSignificantBits = (long)uuidArray[0] << 32 | (long)uuidArray[1] & 0xFFFFFFFFL;
            long leastSignificantBits = (long)uuidArray[2] << 32 | (long)uuidArray[3] & 0xFFFFFFFFL;
            return new UUID(mostSignificantBits, leastSignificantBits);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CompoundTag writeBlockPos(BlockPos blockPos) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt(X_TAG, blockPos.getX());
        compoundTag.putInt(Y_TAG, blockPos.getY());
        compoundTag.putInt(Z_TAG, blockPos.getZ());
        return compoundTag;
    }

    public static BlockPos readBlockPos(CompoundTag compoundTag) {
        if (!(compoundTag != null && compoundTag.contains(X_TAG) && compoundTag.contains(Y_TAG) && compoundTag.contains(Z_TAG))) {
            return BlockPos.ZERO;
        }
        return new BlockPos(compoundTag.getInt(X_TAG).orElse(0).intValue(), compoundTag.getInt(Y_TAG).orElse(0).intValue(), compoundTag.getInt(Z_TAG).orElse(0).intValue());
    }

    public static CompoundTag writeScale(float x, float y, float z) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putFloat(X_TAG, x);
        compoundTag.putFloat(Y_TAG, y);
        compoundTag.putFloat(Z_TAG, z);
        return compoundTag;
    }

    public static CompoundTag writeCustomScale(CustomScale customScale) {
        return CompoundTagUtils.writeScale(customScale.x(), customScale.y(), customScale.z());
    }

    public static CustomScale readCustomScale(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return null;
        }
        return new CustomScale(compoundTag.getFloat(X_TAG).orElse(Float.valueOf(0.0f)).floatValue(), compoundTag.getFloat(Y_TAG).orElse(Float.valueOf(0.0f)).floatValue(), compoundTag.getFloat(Z_TAG).orElse(Float.valueOf(0.0f)).floatValue());
    }

    public static ResourceLocation readResourceLocation(CompoundTag compoundTag, String name) {
        if (compoundTag == null || !compoundTag.contains(name)) {
            return null;
        }
        String resourceLocationString = compoundTag.getString(name).orElse("");
        if (resourceLocationString.isEmpty()) {
            return null;
        }
        if (!resourceLocationString.contains(":")) {
            return ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)resourceLocationString);
        }
        String namespace = compoundTag.getString(name).orElse("").split(":")[0];
        String path = compoundTag.getString(name).orElse("").split(":")[1];
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static ListTag writeResourceLocations(Set<ResourceLocation> resourceLocations) {
        ListTag listTag = new ListTag();
        resourceLocations.forEach(resourceLocation -> {
            int hashCode = resourceLocation.hashCode();
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString(ID_PREFIX + hashCode, resourceLocation.toString());
            listTag.add((Object)compoundTag);
        });
        return listTag;
    }

    public static Set<ResourceLocation> readResourceLocations(ListTag listTag) {
        HashSet<ResourceLocation> resourceLocations = new HashSet<ResourceLocation>();
        listTag.forEach(tag -> {
            CompoundTag compoundTag = (CompoundTag)tag;
            compoundTag.keySet().forEach(key -> {
                if (key.startsWith(ID_PREFIX)) {
                    resourceLocations.add(CompoundTagUtils.readResourceLocation(compoundTag, key));
                }
            });
        });
        return resourceLocations;
    }
}

