/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_630;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCModelManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final class_630 rootModelPart;
    private final Function<class_2960, class_1921> renderType;
    private final Map<ModelPartType, CustomPosition> defaultModelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    private final Map<ModelPartType, CustomRotation> defaultModelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    private final Map<ModelPartType, CustomScale> defaultModelPartScaleMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
    private final Map<ModelPartType, Boolean> defaultModelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    private final Map<ModelPartType, class_630> modelPartMap = new EnumMap<ModelPartType, class_630>(ModelPartType.class);

    public EasyNPCModelManager(class_630 rootModelPart) {
        this(rootModelPart, class_1921::method_23578);
    }

    public EasyNPCModelManager(class_630 rootModelPart, Function<class_2960, class_1921> renderType) {
        this.rootModelPart = rootModelPart;
        this.renderType = renderType;
    }

    public EasyNPCModelManager defineModelPart(ModelPartType modelPartType, String modelPartName) {
        if (this.rootModelPart != null && this.rootModelPart.method_41919(modelPartName)) {
            return this.defineModelPart(modelPartType, this.rootModelPart.method_32086(modelPartName));
        }
        log.error("Model part '{}' not found for model part type '{}' in {}.", (Object)modelPartName, (Object)modelPartType.getTagName(), (Object)this.rootModelPart);
        return this;
    }

    public EasyNPCModelManager defineModelPart(ModelPartType modelPartType, class_630 modelPart) {
        this.setDefaultModelPartPosition(modelPartType, new CustomPosition(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655));
        this.setDefaultModelPartRotation(modelPartType, new CustomRotation(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674));
        this.setDefaultModelPartScale(modelPartType, new CustomScale(modelPart.field_37938, modelPart.field_37939, modelPart.field_37940));
        this.setDefaultModelPartVisibility(modelPartType, modelPart.field_3665);
        this.setDefaultModelPart(modelPartType, modelPart);
        return this;
    }

    public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.defaultModelPartPositionMap.put(modelPartType, customPosition);
    }

    public void setDefaultModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        this.defaultModelPartRotationMap.put(modelPartType, rotation);
    }

    public void setDefaultModelPartScale(ModelPartType modelPartType, CustomScale customScale) {
        this.defaultModelPartScaleMap.put(modelPartType, customScale);
    }

    public void setDefaultModelPartVisibility(ModelPartType modelPartType, boolean isVisible) {
        this.defaultModelPartVisibilityMap.put(modelPartType, isVisible);
    }

    public void setDefaultModelPart(ModelPartType modelPartType, class_630 modelPart) {
        this.modelPartMap.put(modelPartType, modelPart);
    }

    public class_630 getModelPart(ModelPartType modelPartType) {
        return this.modelPartMap.get((Object)modelPartType);
    }

    public boolean setupModelParts(ModelDataCapable<?> modelData) {
        if (modelData == null || modelData.getModelPose() == ModelPose.DEFAULT) {
            return false;
        }
        boolean hasChangedModelPart = false;
        for (Map.Entry<ModelPartType, class_630> entry : this.modelPartMap.entrySet()) {
            CustomScale customScale;
            CustomRotation customRotation;
            CustomPosition customPosition;
            ModelPartType partType = entry.getKey();
            class_630 modelPart = entry.getValue();
            if (partType == ModelPartType.HAT) continue;
            Boolean visibility = modelData.getModelPartVisibility(partType);
            if (Boolean.FALSE.equals(visibility)) {
                modelPart.field_3665 = false;
                continue;
            }
            if (Boolean.TRUE.equals(visibility) && Boolean.TRUE.equals(this.defaultModelPartVisibilityMap.get((Object)partType))) {
                modelPart.field_3665 = true;
            }
            if ((customPosition = modelData.getModelPartPosition(partType)) != null && customPosition.hasChanged()) {
                modelPart.field_3657 += customPosition.x();
                modelPart.field_3656 += customPosition.y();
                modelPart.field_3655 += customPosition.z();
                hasChangedModelPart = true;
            }
            if ((customRotation = modelData.getModelPartRotation(partType)) != null && customRotation.hasChanged()) {
                modelPart.field_3654 += customRotation.x();
                modelPart.field_3675 += customRotation.y();
                modelPart.field_3674 += customRotation.z();
                hasChangedModelPart = true;
            }
            if ((customScale = modelData.getModelPartScale(partType)) == null || !customScale.hasChanged()) continue;
            CustomScale defaultScale = this.defaultModelPartScaleMap.get((Object)partType);
            if (defaultScale != null) {
                modelPart.field_37938 = defaultScale.x() * customScale.x();
                modelPart.field_37939 = defaultScale.y() * customScale.y();
                modelPart.field_37940 = defaultScale.z() * customScale.z();
            } else {
                modelPart.field_37938 = customScale.x();
                modelPart.field_37939 = customScale.y();
                modelPart.field_37940 = customScale.z();
            }
            hasChangedModelPart = true;
        }
        this.syncModelParts(modelData);
        return hasChangedModelPart;
    }

    public void syncModelParts(ModelDataCapable<?> modelData) {
        if (modelData == null || modelData.getModelPose() == ModelPose.DEFAULT) {
            return;
        }
        class_630 hatModelPart = this.modelPartMap.get((Object)ModelPartType.HAT);
        class_630 headModelPart = this.modelPartMap.get((Object)ModelPartType.HEAD);
        if (hatModelPart != null && headModelPart != null && Boolean.TRUE.equals(this.defaultModelPartVisibilityMap.get((Object)ModelPartType.HAT))) {
            hatModelPart.field_3665 = headModelPart.field_3665;
        }
    }

    public void resetModelParts() {
        for (Map.Entry<ModelPartType, class_630> entry : this.modelPartMap.entrySet()) {
            ModelPartType modelPartType = entry.getKey();
            class_630 modelPartToRest = entry.getValue();
            if (modelPartType == ModelPartType.HAT) continue;
            CustomPosition customPosition = this.defaultModelPartPositionMap.get((Object)modelPartType);
            CustomRotation customRotation = this.defaultModelPartRotationMap.get((Object)modelPartType);
            CustomScale customScale = this.defaultModelPartScaleMap.get((Object)modelPartType);
            Boolean isVisible = this.defaultModelPartVisibilityMap.get((Object)modelPartType);
            if (customPosition != null) {
                modelPartToRest.method_2851(customPosition.x(), customPosition.y(), customPosition.z());
            }
            if (customRotation != null) {
                modelPartToRest.method_33425(customRotation.x(), customRotation.y(), customRotation.z());
            }
            if (customScale != null) {
                modelPartToRest.field_37938 = customScale.x();
                modelPartToRest.field_37939 = customScale.y();
                modelPartToRest.field_37940 = customScale.z();
            }
            if (isVisible == null) continue;
            modelPartToRest.field_3665 = isVisible;
        }
    }
}

