/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionGroup;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.class_1308;
import net.minecraft.class_3222;

public class ActionManager {
    private static final HashMap<class_1308, EnumMap<ActionGroup, HashSet<class_3222>>> actionGroupPlayerMap = new HashMap();

    private ActionManager() {
    }

    public static void addPlayer(class_1308 mob, ActionGroup actionGroup, class_3222 serverPlayer) {
        HashSet<Object> playerList;
        if (mob == null || actionGroup == null || serverPlayer == null) {
            return;
        }
        EnumMap<ActionGroup, HashSet<Object>> actionGroupPlayer = actionGroupPlayerMap.get(mob);
        if (actionGroupPlayer == null) {
            actionGroupPlayer = new EnumMap(ActionGroup.class);
        }
        if ((playerList = actionGroupPlayer.get((Object)actionGroup)) == null) {
            playerList = new HashSet();
        }
        playerList.add(serverPlayer);
        actionGroupPlayer.put(actionGroup, playerList);
        actionGroupPlayerMap.put(mob, actionGroupPlayer);
    }

    public static boolean containsPlayer(class_1308 mob, ActionGroup actionGroup, class_3222 serverPlayer) {
        if (mob == null || actionGroup == null || serverPlayer == null) {
            return false;
        }
        EnumMap<ActionGroup, HashSet<class_3222>> actionGroupPlayer = actionGroupPlayerMap.get(mob);
        if (actionGroupPlayer == null) {
            return false;
        }
        HashSet<class_3222> playerList = actionGroupPlayer.get((Object)actionGroup);
        if (playerList == null) {
            return false;
        }
        return playerList.contains(serverPlayer);
    }

    public static void removePlayer(class_1308 mob, ActionGroup actionGroup, class_3222 serverPlayer) {
        if (mob == null || actionGroup == null || serverPlayer == null) {
            return;
        }
        EnumMap<ActionGroup, HashSet<class_3222>> actionGroupPlayer = actionGroupPlayerMap.get(mob);
        if (actionGroupPlayer == null) {
            return;
        }
        HashSet<class_3222> playerList = actionGroupPlayer.get((Object)actionGroup);
        if (playerList == null || !playerList.contains(serverPlayer)) {
            return;
        }
        playerList.remove(serverPlayer);
        actionGroupPlayer.put(actionGroup, playerList);
        actionGroupPlayerMap.put(mob, actionGroupPlayer);
    }

    public static void removeActionGroup(class_1308 mob, ActionGroup actionGroup) {
        if (mob == null || actionGroup == null) {
            return;
        }
        EnumMap<ActionGroup, HashSet<class_3222>> actionGroupPlayer = actionGroupPlayerMap.get(mob);
        if (actionGroupPlayer == null || !actionGroupPlayer.containsKey((Object)actionGroup)) {
            return;
        }
        actionGroupPlayer.remove((Object)actionGroup);
        actionGroupPlayerMap.put(mob, actionGroupPlayer);
    }
}

