/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.sound;

import de.markusbordihn.easynpc.data.sound.SoundDataEntry;
import de.markusbordihn.easynpc.data.sound.SoundType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class SoundDataSet {
    public static final String DATA_SOUND_DATA_SET_TAG = "SoundDataSet";
    public static final class_9139<class_9129, SoundDataSet> STREAM_CODEC = new class_9139<class_9129, SoundDataSet>(){

        public SoundDataSet decode(class_9129 registryFriendlyByteBuf) {
            return new SoundDataSet(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, SoundDataSet soundDataSet) {
            registryFriendlyByteBuf.method_10794((class_2520)soundDataSet.createTag());
        }
    };
    private final Map<SoundType, SoundDataEntry> defaultSounds = new EnumMap<SoundType, SoundDataEntry>(SoundType.class);
    private final Map<SoundType, SoundDataEntry> overrideSounds = new EnumMap<SoundType, SoundDataEntry>(SoundType.class);

    public SoundDataSet() {
    }

    public SoundDataSet(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public boolean hasSound(SoundType type) {
        return this.defaultSounds.containsKey((Object)type) || this.overrideSounds.containsKey((Object)type);
    }

    public void addSound(SoundType type, class_3414 soundEvent) {
        this.addSound(type, soundEvent.comp_3319());
    }

    public void addSound(SoundType type, class_2960 resourceLocation) {
        if (resourceLocation == null || resourceLocation.toString().isEmpty()) {
            return;
        }
        if (this.defaultSounds.containsKey((Object)type) && this.defaultSounds.get((Object)type).getSoundEvent().comp_3319().equals((Object)resourceLocation)) {
            this.overrideSounds.remove((Object)type);
        } else {
            this.overrideSounds.put(type, new SoundDataEntry(type, resourceLocation));
        }
    }

    public void addDefaultSound(SoundType type, class_3414 soundEvent) {
        if (soundEvent == null || soundEvent.comp_3319().toString().isEmpty()) {
            return;
        }
        this.defaultSounds.put(type, new SoundDataEntry(type, soundEvent.comp_3319()));
    }

    public boolean isEmpty() {
        return this.defaultSounds.isEmpty() && this.overrideSounds.isEmpty();
    }

    public SoundDataEntry getSound(SoundType type) {
        return this.overrideSounds.containsKey((Object)type) ? this.overrideSounds.get((Object)type) : this.defaultSounds.get((Object)type);
    }

    public void load(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_SOUND_DATA_SET_TAG)) {
            return;
        }
        this.overrideSounds.clear();
        class_2499 soundListTag = compoundTag.method_10554(DATA_SOUND_DATA_SET_TAG, 10);
        for (int i = 0; i < soundListTag.size(); ++i) {
            class_2487 soundDataTag = soundListTag.method_10602(i);
            SoundDataEntry soundDataEntry = new SoundDataEntry(soundDataTag);
            SoundType type = soundDataEntry.getType();
            class_3414 event = soundDataEntry.getSoundEvent();
            if (type == null || event == null || this.defaultSounds.containsKey((Object)type) && this.defaultSounds.get((Object)type).getSoundEvent().equals((Object)event)) continue;
            this.overrideSounds.put(type, soundDataEntry);
        }
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2499 soundListTag = new class_2499();
        for (Map.Entry<SoundType, SoundDataEntry> entry : this.overrideSounds.entrySet()) {
            SoundDataEntry soundDataEntry = entry.getValue();
            soundListTag.add((Object)soundDataEntry.createTag());
        }
        compoundTag.method_10566(DATA_SOUND_DATA_SET_TAG, (class_2520)soundListTag);
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }
}

