/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.custom;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.Mth;

public class FairyModel<S extends HumanoidRenderState>
extends HumanoidModel<S> {
    public static final float MODEL_OFFSET_Y = -1.0f;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public FairyModel(ModelPart modelPart) {
        super(modelPart);
        this.leftLeg.visible = false;
        this.hat.visible = false;
        this.leftWing = modelPart.getChild("body").getChild("left_wing");
        this.rightWing = modelPart.getChild("body").getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)-1.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 25).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 25).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 41).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 41).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 15.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(56, 14).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-5.0f, (float)1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(56, 14).mirror().addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(20, 57).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)5.0f, (float)1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(44, 55).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 41).addBox(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(42, 0).addBox(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-1.9f, (float)11.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -8.0f, 0.0f, 20.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.5f, (float)2.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).addBox(-20.0f, -8.0f, 0.0f, 20.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public void setupAnim(S renderState) {
        super.setupAnim(renderState);
        this.rightWing.yRot = 0.47123894f + Mth.cos((float)(((HumanoidRenderState)renderState).ageInTicks * 20.0f * ((float)Math.PI / 180))) * (float)Math.PI * 0.15f;
        this.leftWing.yRot = -this.rightWing.yRot;
        this.leftWing.zRot = -0.47123894f;
        this.leftWing.xRot = 0.47123894f;
        this.rightWing.xRot = 0.47123894f;
        this.rightWing.zRot = 0.47123894f;
        this.leftLeg.visible = false;
    }
}

