/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionOperationType;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public record ConditionDataEntry(UUID id, ConditionType conditionType, ConditionOperationType operationType, String name, int value, String stringValue) {
    public static final ConditionDataEntry EMPTY = new ConditionDataEntry(ConditionType.NONE, ConditionOperationType.NONE);
    public static final String DATA_UUID_TAG = "UUID";
    public static final String DATA_TYPE_TAG = "Type";
    public static final String DATA_OPERATION_TAG = "Operation";
    public static final String DATA_NAME_TAG = "Name";
    public static final String DATA_VALUE_TAG = "Value";
    public static final String DATA_STRING_VALUE_TAG = "StringValue";

    public ConditionDataEntry(CompoundTag compoundTag) {
        this(compoundTag.contains(DATA_UUID_TAG) ? compoundTag.getUUID(DATA_UUID_TAG) : UUID.randomUUID(), ConditionType.get(compoundTag.getString(DATA_TYPE_TAG)), ConditionOperationType.get(compoundTag.getString(DATA_OPERATION_TAG)), compoundTag.contains(DATA_NAME_TAG) ? compoundTag.getString(DATA_NAME_TAG) : "", compoundTag.contains(DATA_VALUE_TAG) ? compoundTag.getInt(DATA_VALUE_TAG) : 0, compoundTag.contains(DATA_STRING_VALUE_TAG) ? compoundTag.getString(DATA_STRING_VALUE_TAG) : "");
    }

    public ConditionDataEntry(ConditionType conditionType) {
        this(conditionType, ConditionOperationType.NONE);
    }

    public ConditionDataEntry(ConditionType conditionType, ConditionOperationType operationType) {
        this(UUID.randomUUID(), conditionType, operationType, "", 0, "");
    }

    public ConditionDataEntry(ConditionType conditionType, ConditionOperationType operationType, String name, int value) {
        this(UUID.randomUUID(), conditionType, operationType, name, value, "");
    }

    public UUID getId() {
        return this.id;
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasStringValue() {
        return this.stringValue != null && !this.stringValue.isEmpty();
    }

    public boolean isValid() {
        if (this.conditionType == ConditionType.NONE) {
            return false;
        }
        return switch (this.conditionType) {
            case ConditionType.SCOREBOARD -> {
                if (this.hasName() && this.operationType != null && this.operationType != ConditionOperationType.NONE) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public ConditionDataEntry withConditionType(ConditionType conditionType) {
        return new ConditionDataEntry(this.id, conditionType, this.operationType, this.name, this.value, this.stringValue);
    }

    public ConditionDataEntry withOperationType(ConditionOperationType operationType) {
        return new ConditionDataEntry(this.id, this.conditionType, operationType, this.name, this.value, this.stringValue);
    }

    public ConditionDataEntry withName(String name) {
        return new ConditionDataEntry(this.id, this.conditionType, this.operationType, name, this.value, this.stringValue);
    }

    public ConditionDataEntry withValue(int value) {
        return new ConditionDataEntry(this.id, this.conditionType, this.operationType, this.name, value, this.stringValue);
    }

    public ConditionDataEntry withStringValue(String stringValue) {
        return new ConditionDataEntry(this.id, this.conditionType, this.operationType, this.name, this.value, stringValue);
    }

    public ConditionDataEntry create(CompoundTag compoundTag) {
        return new ConditionDataEntry(compoundTag);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        compoundTag.putUUID(DATA_UUID_TAG, this.id);
        compoundTag.putString(DATA_TYPE_TAG, this.conditionType.name());
        if (this.operationType != null && this.operationType != ConditionOperationType.NONE) {
            compoundTag.putString(DATA_OPERATION_TAG, this.operationType.name());
        }
        if (this.hasName()) {
            compoundTag.putString(DATA_NAME_TAG, this.name.trim());
        }
        if (this.value != 0) {
            compoundTag.putInt(DATA_VALUE_TAG, this.value);
        }
        if (this.hasStringValue()) {
            compoundTag.putString(DATA_STRING_VALUE_TAG, this.stringValue);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    @Override
    public String toString() {
        return "ConditionDataEntry[id=" + String.valueOf(this.id) + ", type=" + String.valueOf((Object)this.conditionType) + ", operation=" + String.valueOf((Object)this.operationType) + ", name='" + this.name + "', value=" + this.value + ", stringValue='" + this.stringValue + "']";
    }
}

