/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.render;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.render.ScissorBox;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;

public record EntityRenderConfig(int x, int y, int scale, float rotationYaw, float rotationPitch, EntityRenderOverrides overrides, ScissorBox scissorBox) {
    public static EntityRenderConfig guiScaled(int x, int y, int scale, float rotationYaw, float rotationPitch) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.HIDE_NAME_TAG_RESET_ROOT, ScissorBox.NONE);
    }

    public static EntityRenderConfig dialog(int x, int y, int scale, float rotationYaw, float rotationPitch) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.HIDE_NAME_TAG, ScissorBox.NONE);
    }

    public static EntityRenderConfig customPose(int x, int y, int scale, float rotationYaw, float rotationPitch) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.withCustomPose(ModelPose.CUSTOM, Pose.STANDING).withHideNameTag(true), ScissorBox.NONE);
    }

    public static EntityRenderConfig scaling(int x, int y, int scale, float rotationYaw, float rotationPitch) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.NONE.withRootRotation(new CustomRotation(0.0f, 0.0f, 0.0f)).withHideNameTag(true), ScissorBox.NONE);
    }

    public static EntityRenderConfig customModel(int x, int y, int scale, float rotationYaw, float rotationPitch, EntityType<?> entityType) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.withCustomModel(RenderType.CUSTOM, entityType), ScissorBox.NONE);
    }

    public static EntityRenderConfig withOverrides(int x, int y, int scale, float rotationYaw, float rotationPitch, EntityRenderOverrides overrides) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, overrides, ScissorBox.NONE);
    }

    public EntityRenderConfig withScissorBox(ScissorBox scissorBox) {
        return new EntityRenderConfig(this.x, this.y, this.scale, this.rotationYaw, this.rotationPitch, this.overrides, scissorBox);
    }
}

