/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.scoreboard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;

public class ScoreboardData {
    private static final Pattern SCORE_PATTERN = Pattern.compile("@score\\(([a-zA-Z0-9_.-]+)\\)");
    private static final String SCORES_TAG = "Scores";
    private final Map<String, Integer> scores = new HashMap<String, Integer>();

    public ScoreboardData() {
    }

    public ScoreboardData(CompoundTag compoundTag) {
        this();
        if (compoundTag != null && compoundTag.contains(SCORES_TAG)) {
            CompoundTag scoresTag = compoundTag.getCompound(SCORES_TAG);
            for (String key : scoresTag.getAllKeys()) {
                this.scores.put(key, scoresTag.getInt(key));
            }
        }
    }

    public ScoreboardData(ServerPlayer serverPlayer, Set<String> objectiveNames) {
        this();
        if (serverPlayer != null && objectiveNames != null) {
            Scoreboard scoreboard = serverPlayer.getScoreboard();
            for (String objectiveName : objectiveNames) {
                if (!ScoreboardData.isValidObjectiveName(objectiveName)) continue;
                this.scores.put(objectiveName, ScoreboardData.getScoreboardValue(scoreboard, serverPlayer, objectiveName));
            }
        }
    }

    public static Set<String> parseScoreMacros(String text) {
        HashSet<String> objectiveNames = new HashSet<String>();
        if (text == null || text.isEmpty()) {
            return objectiveNames;
        }
        Matcher matcher = SCORE_PATTERN.matcher(text);
        while (matcher.find()) {
            String objectiveName = matcher.group(1);
            if (!ScoreboardData.isValidObjectiveName(objectiveName)) continue;
            objectiveNames.add(objectiveName);
        }
        return objectiveNames;
    }

    private static boolean isValidObjectiveName(String objectiveName) {
        return objectiveName != null && !objectiveName.isEmpty() && objectiveName.length() <= 32 && objectiveName.matches("[a-zA-Z0-9_.-]+");
    }

    private static int getScoreboardValue(Scoreboard scoreboard, ServerPlayer player, String objectiveName) {
        Objective objective = scoreboard.getObjective(objectiveName);
        if (objective != null) {
            return scoreboard.getOrCreatePlayerScore((ScoreHolder)player, objective).get();
        }
        return 0;
    }

    public int getScore(String objectiveName) {
        return this.scores.getOrDefault(objectiveName, 0);
    }

    public boolean hasScore(String objectiveName) {
        return this.scores.containsKey(objectiveName);
    }

    public CompoundTag createTag() {
        CompoundTag compoundTag = new CompoundTag();
        if (!this.scores.isEmpty()) {
            CompoundTag scoresTag = new CompoundTag();
            for (Map.Entry<String, Integer> entry : this.scores.entrySet()) {
                scoresTag.putInt(entry.getKey(), entry.getValue().intValue());
            }
            compoundTag.put(SCORES_TAG, (Tag)scoresTag);
        }
        return compoundTag;
    }

    public String toString() {
        return "ScoreboardData{scores=" + String.valueOf(this.scores) + "}";
    }
}

