/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.BowItem;

public class BowAttackGoal<T extends EasyNPC<?>>
extends Goal {
    private final PathfinderMob pathfinderMob;
    private final RangedAttackMob rangedAttackMob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackIntervalMin;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingBackwards;
    private boolean strafingClockwise;
    private int strafingTime = -1;

    public BowAttackGoal(T easyNPC, double targetDistance, int hasLineOfSight, float hasSeen) {
        this.pathfinderMob = easyNPC.getPathfinderMob();
        this.rangedAttackMob = easyNPC.getRangedAttackMob();
        this.speedModifier = targetDistance;
        this.attackIntervalMin = hasLineOfSight;
        this.attackRadiusSqr = hasSeen * hasSeen;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setMinAttackInterval(int livingEntity) {
        this.attackIntervalMin = livingEntity;
    }

    public boolean canUse() {
        return this.pathfinderMob.getTarget() != null && AttackHandler.isHoldingBowWeapon((LivingEntity)this.pathfinderMob);
    }

    public boolean canContinueToUse() {
        return (this.canUse() || !this.pathfinderMob.getNavigation().isDone()) && AttackHandler.isHoldingBowWeapon((LivingEntity)this.pathfinderMob);
    }

    public void start() {
        super.start();
        this.pathfinderMob.setAggressive(true);
    }

    public void stop() {
        super.stop();
        this.pathfinderMob.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.pathfinderMob.stopUsingItem();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingEntity = this.pathfinderMob.getTarget();
        if (livingEntity != null) {
            boolean hasSeen;
            double targetDistance = this.pathfinderMob.distanceToSqr(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
            boolean hasLineOfSight = this.pathfinderMob.getSensing().hasLineOfSight((Entity)livingEntity);
            boolean bl = hasSeen = this.seeTime > 0;
            if (hasLineOfSight != hasSeen) {
                this.seeTime = 0;
            }
            this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
            if (targetDistance <= (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.pathfinderMob.getNavigation().stop();
                ++this.strafingTime;
            } else {
                this.pathfinderMob.getNavigation().moveTo((Entity)livingEntity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.pathfinderMob.getRandom().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.pathfinderMob.getRandom().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (targetDistance > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (targetDistance < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.pathfinderMob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.pathfinderMob.lookAt((Entity)livingEntity, 30.0f, 30.0f);
            } else {
                this.pathfinderMob.getLookControl().setLookAt((Entity)livingEntity, 30.0f, 30.0f);
            }
            if (this.pathfinderMob.isUsingItem()) {
                int chargingTime;
                if (!hasLineOfSight && this.seeTime < -60) {
                    this.pathfinderMob.stopUsingItem();
                } else if (hasLineOfSight && (chargingTime = this.pathfinderMob.getTicksUsingItem()) >= 20) {
                    this.pathfinderMob.stopUsingItem();
                    this.rangedAttackMob.performRangedAttack(livingEntity, BowItem.getPowerForTime((int)chargingTime));
                    this.attackTime = this.attackIntervalMin;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.pathfinderMob.startUsingItem(AttackHandler.getBowHoldingHand((LivingEntity)this.pathfinderMob));
            }
        }
    }
}

