/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.status.StatusDataType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.PathfinderMob;

public interface StatusDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String DATA_STATUS_DATA_TAG = "Status";

    public EnumMap<StatusDataType, Boolean> getStatusDataFlags();

    default public boolean getStatusDataFlag(StatusDataType key) {
        return this.getStatusDataFlags().getOrDefault((Object)key, false);
    }

    default public void setStatusDataFlag(StatusDataType key, boolean value) {
        this.getStatusDataFlags().put(key, value);
    }

    default public void addAdditionalStatusData(CompoundTag compoundTag) {
        CompoundTag statusTag = new CompoundTag();
        if (!this.getStatusDataFlag(StatusDataType.FINALIZED)) {
            this.setStatusDataFlag(StatusDataType.FINALIZED, true);
        }
        for (Map.Entry<StatusDataType, Boolean> entry : this.getStatusDataFlags().entrySet()) {
            statusTag.putBoolean(entry.getKey().getTagName(), entry.getValue().booleanValue());
        }
        compoundTag.put(DATA_STATUS_DATA_TAG, (Tag)statusTag);
    }

    default public void readAdditionalStatusData(CompoundTag compoundTag) {
        if (!compoundTag.contains(DATA_STATUS_DATA_TAG)) {
            return;
        }
        CompoundTag statusTag = compoundTag.getCompound(DATA_STATUS_DATA_TAG);
        for (String key : statusTag.getAllKeys()) {
            StatusDataType statusDataType = StatusDataType.get(key);
            if (statusDataType == null) continue;
            this.setStatusDataFlag(StatusDataType.get(key), statusTag.getBoolean(key));
        }
    }
}

