/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandExecutor {
    protected static final Logger log = LogManager.getLogger(CommandExecutor.class);
    private static final Set<String> BLOCKED_UNSAFE_NPC_COMMANDS = new HashSet<String>(List.of("ban-ip", "ban", "banlist", "debug", "deop", "difficulty", "forceload", "gamerule", "kick", "op", "pardon", "reload", "save-all", "save-off", "save-on", "setidletimeout", "setworldspawn", "stop", "whitelist"));

    private CommandExecutor() {
    }

    public static boolean isBlockedUnsafeNPCCommand(String command) {
        String[] runParts;
        String relevant;
        if (command == null || command.isBlank()) {
            return false;
        }
        String cmd = command.trim();
        if (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        if ((relevant = (runParts = cmd.split("\\s+run\\s+"))[runParts.length - 1].trim()).startsWith("/")) {
            relevant = relevant.substring(1);
        }
        String mainCmd = relevant.split(" ")[0].toLowerCase(Locale.ROOT);
        return BLOCKED_UNSAFE_NPC_COMMANDS.contains(mainCmd);
    }

    public static void executeEntityCommand(String command, Entity entity, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = entity.getServer();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for entity {}", (Object)entity);
            return;
        }
        if (CommandExecutor.isBlockedUnsafeNPCCommand(command)) {
            log.warn("Blocked unsafe entity command {} for {} with permission level {}!", (Object)command, (Object)entity, (Object)permissionLevel);
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Entity {} Command: \"{}\" with permission level {}", (Object)entity, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.getCommands();
        CommandSourceStack commandSourceStack = minecraftServer.createCommandSourceStack().withEntity(entity).withPosition(entity.position()).withRotation(entity.getRotationVector()).withPermission(permissionLevel);
        CommandDispatcher commandDispatcher = commands.getDispatcher();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.withSuppressedOutput()));
        commands.performCommand(parseResults, command);
    }

    public static void executePlayerCommand(String command, ServerPlayer serverPlayer, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = serverPlayer.getServer();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for player {}", (Object)serverPlayer);
            return;
        }
        if (CommandExecutor.isBlockedUnsafeNPCCommand(command)) {
            log.warn("Blocked unsafe player command {} for {} with permission level {}!", (Object)command, (Object)serverPlayer, (Object)permissionLevel);
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Player {} Command: \"{}\" with permission level {}", (Object)serverPlayer, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.getCommands();
        CommandSourceStack commandSourceStack = minecraftServer.createCommandSourceStack().withEntity((Entity)serverPlayer).withPosition(serverPlayer.position()).withRotation(serverPlayer.getRotationVector()).withPermission(permissionLevel).withLevel(serverPlayer.serverLevel());
        CommandDispatcher commandDispatcher = commands.getDispatcher();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.withSuppressedOutput()));
        commands.performCommand(parseResults, command);
    }
}

