/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import com.google.common.collect.ImmutableList;
import de.markusbordihn.easynpc.data.configuration.ConfigurationData;
import de.markusbordihn.easynpc.data.skin.variant.VillagerSkinVariant;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.VillagerRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VillagerNPC
extends VillagerRaw
implements StandardEasyNPC<VillagerRaw> {
    public static final String ID = "villager";
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.ANGRY_AT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.HEARD_BELL_TIME, (Object)MemoryModuleType.HOME, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.JOB_SITE, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.MEETING_POINT, (Object)MemoryModuleType.NEAREST_PLAYERS, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.PATH, MemoryModuleType.POTENTIAL_JOB_SITE, MemoryModuleType.WALK_TARGET});
    private static final ImmutableList<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.GOLEM_DETECTED, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_BED, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.SECONDARY_POIS, (Object)SensorType.VILLAGER_BABIES, (Object)SensorType.VILLAGER_HOSTILES);

    public VillagerNPC(EntityType<? extends Villager> entityType, Level level) {
        this(entityType, level, VillagerSkinVariant.PLAINS_NITWIT);
    }

    public VillagerNPC(EntityType<? extends Villager> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.setInvulnerable(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    @Override
    public boolean canUseOffHand() {
        return false;
    }

    @Override
    public Component getName() {
        Component component = this.getCustomName();
        if (component != null) {
            return TextUtils.removeAction(component);
        }
        Component professionName = this.getProfessionName();
        Component variantName = this.getSkinVariantTypeName();
        return TextComponent.getText(variantName.getString() + " (" + professionName.getString() + ")");
    }

    public boolean wantsToSpawnGolem(long gameTime) {
        return false;
    }

    @Override
    public boolean hasProfessions() {
        return true;
    }

    @Override
    public ConfigurationData getConfigurationData() {
        return ConfigurationData.STANDARD;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.VILLAGER_AMBIENT);
        soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.VILLAGER_DEATH);
        soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.VILLAGER_HURT);
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void registerGoals() {
    }

    protected Brain.Provider<Villager> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

