/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveDataCapable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectiveHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ObjectiveHandler() {
    }

    public static boolean addOrUpdateCustomObjective(EasyNPC<?> easyNPC, ObjectiveDataEntry objectiveDataEntry) {
        if (easyNPC == null || objectiveDataEntry == null) {
            log.error("[{}] Error adding or updating custom objective!", easyNPC);
            return false;
        }
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null) {
            log.error("[{}] No objective data available!", easyNPC);
            return false;
        }
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            log.error("[{}] Error adding or updating custom objective!", easyNPC);
            return false;
        }
        if (log.isDebugEnabled()) {
            ObjectiveHandler.logObjectiveGoals(objectiveData.getEntityGoalSelector().getAvailableGoals());
            ObjectiveHandler.logObjectiveTargets(objectiveData.getEntityTargetSelector().getAvailableGoals());
        }
        return true;
    }

    public static boolean removeCustomObjective(EasyNPC<?> easyNPC, ObjectiveDataEntry objectiveDataEntry) {
        if (easyNPC == null || objectiveDataEntry == null) {
            log.error("[{}] Error removing custom objective!", easyNPC);
            return false;
        }
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null) {
            log.error("[{}] No objective data available!", easyNPC);
            return false;
        }
        if (!objectiveData.removeCustomObjective(objectiveDataEntry)) {
            log.error("[{}] Error removing custom objective!", easyNPC);
            return false;
        }
        if (log.isDebugEnabled()) {
            ObjectiveHandler.logObjectiveGoals(objectiveData.getEntityGoalSelector().getAvailableGoals());
            ObjectiveHandler.logObjectiveTargets(objectiveData.getEntityTargetSelector().getAvailableGoals());
        }
        return true;
    }

    public static void logObjectiveGoals(Set<WrappedGoal> goals) {
        List<Goal> unwrappedGoals = ObjectiveHandler.getUnwrappedGoals(goals);
        if (goals != null && !goals.isEmpty() && !unwrappedGoals.isEmpty()) {
            log.debug("Goals: {}", unwrappedGoals);
        }
    }

    public static void logObjectiveTargets(Set<WrappedGoal> goals) {
        List<Goal> unwrappedGoals = ObjectiveHandler.getUnwrappedGoals(goals);
        if (goals != null && !goals.isEmpty() && !unwrappedGoals.isEmpty()) {
            log.debug("Targets: {}", unwrappedGoals);
        }
    }

    public static List<Goal> getUnwrappedGoals(Set<WrappedGoal> goals) {
        if (goals == null || goals.isEmpty()) {
            return new ArrayList<Goal>();
        }
        ArrayList<Goal> unwrappedGoals = new ArrayList<Goal>();
        for (WrappedGoal wrappedGoal : goals) {
            unwrappedGoals.add(wrappedGoal.getGoal());
        }
        return unwrappedGoals;
    }
}

