/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.mixin.model;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.EasyNPCModelManager;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpiderModel.class})
public class EasyNPCSpiderModelMixin<T extends LivingEntityRenderState> {
    @Shadow
    @Final
    private ModelPart head;
    @Shadow
    @Final
    private ModelPart rightFrontLeg;
    @Shadow
    @Final
    private ModelPart leftFrontLeg;
    @Shadow
    @Final
    private ModelPart rightMiddleFrontLeg;
    @Shadow
    @Final
    private ModelPart leftMiddleFrontLeg;
    @Shadow
    @Final
    private ModelPart rightMiddleHindLeg;
    @Shadow
    @Final
    private ModelPart leftMiddleHindLeg;
    @Shadow
    @Final
    private ModelPart rightHindLeg;
    @Shadow
    @Final
    private ModelPart leftHindLeg;
    @Unique
    private EasyNPCModelManager easyNPC$modelManager;

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;)V"}, at={@At(value="TAIL")})
    private void easyNpcModel(ModelPart modelPart, CallbackInfo callbackInfo) {
        this.easyNPC$modelManager = new EasyNPCModelManager(modelPart).defineModelPart(ModelPartType.HEAD, this.head).defineModelPart(ModelPartType.RIGHT_ARM, this.rightFrontLeg).defineModelPart(ModelPartType.LEFT_ARM, this.leftFrontLeg);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setupNpcAnimStart(T renderState, CallbackInfo callbackInfo) {
        EasyNPCRenderStateExtension extension;
        if (renderState instanceof EasyNPCRenderStateExtension && EasyNPCModel.setupAnimationStart(extension = (EasyNPCRenderStateExtension)renderState, this.easyNPC$modelManager)) {
            callbackInfo.cancel();
        }
    }
}

