/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.trading;

import de.markusbordihn.easynpc.data.trading.TradingType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class TradingDataSet {
    public static final String DATA_TRADING_DATA_SET_TAG = "TradingDataSet";
    public static final String DATA_TRADING_MAX_USES_TAG = "MaxUses";
    public static final String DATA_TRADING_REWARDED_XP_TAG = "RewardedXP";
    public static final String DATA_TRADING_RESETS_EVERY_MIN_TAG = "ResetsEveryMin";
    public static final String DATA_TRADING_LAST_RESET_TAG = "LastReset";
    public static final String DATA_TYPE_TAG = "Type";
    public static final StreamCodec<RegistryFriendlyByteBuf, TradingDataSet> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, TradingDataSet>(){

        public TradingDataSet decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new TradingDataSet(registryFriendlyByteBuf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, TradingDataSet tradingDataSet) {
            registryFriendlyByteBuf.writeNbt((Tag)tradingDataSet.createTag());
        }
    };
    private TradingType tradingType = TradingType.NONE;
    private int maxUses = 64;
    private int rewardedXP = 0;
    private int resetsEveryMin = 0;
    private long lastReset = 0L;

    public TradingDataSet() {
    }

    public TradingDataSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public TradingType getType() {
        return this.tradingType;
    }

    public void setType(TradingType tradingType) {
        this.tradingType = tradingType;
    }

    public boolean isType(TradingType tradingType) {
        return tradingType != null && this.tradingType == tradingType;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    public int getRewardedXP() {
        return this.rewardedXP;
    }

    public void setRewardedXP(int rewardedXP) {
        this.rewardedXP = rewardedXP;
    }

    public int getResetsEveryMin() {
        return this.resetsEveryMin;
    }

    public void setResetsEveryMin(int resetsEveryMin) {
        this.resetsEveryMin = resetsEveryMin;
    }

    public long getLastReset() {
        return this.lastReset;
    }

    public void setLastReset(long lastReset) {
        this.lastReset = lastReset;
    }

    public void load(CompoundTag compoundTag) {
        if (compoundTag == null || !compoundTag.contains(DATA_TRADING_DATA_SET_TAG)) {
            return;
        }
        CompoundTag tradingData = compoundTag.getCompound(DATA_TRADING_DATA_SET_TAG);
        this.maxUses = tradingData.getInt(DATA_TRADING_MAX_USES_TAG);
        this.rewardedXP = tradingData.getInt(DATA_TRADING_REWARDED_XP_TAG);
        this.resetsEveryMin = tradingData.getInt(DATA_TRADING_RESETS_EVERY_MIN_TAG);
        this.lastReset = tradingData.contains(DATA_TRADING_LAST_RESET_TAG) ? tradingData.getLong(DATA_TRADING_LAST_RESET_TAG) : System.currentTimeMillis();
        this.tradingType = TradingType.valueOf(tradingData.getString(DATA_TYPE_TAG));
    }

    public CompoundTag save(CompoundTag compoundTag) {
        CompoundTag tradingData = new CompoundTag();
        tradingData.putInt(DATA_TRADING_MAX_USES_TAG, this.maxUses);
        tradingData.putInt(DATA_TRADING_REWARDED_XP_TAG, this.rewardedXP);
        tradingData.putInt(DATA_TRADING_RESETS_EVERY_MIN_TAG, this.resetsEveryMin);
        tradingData.putLong(DATA_TRADING_LAST_RESET_TAG, this.lastReset);
        tradingData.putString(DATA_TYPE_TAG, this.tradingType.name());
        compoundTag.put(DATA_TRADING_DATA_SET_TAG, (Tag)tradingData);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }
}

