/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityRendererUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<EntityType<?>, Function<EntityRendererProvider.Context, EntityRenderer<?, ?>>> VANILLA_RENDERER_FACTORIES = Map.of(EntityType.VILLAGER, VillagerRenderer::new, EntityType.ZOMBIE, ZombieRenderer::new, EntityType.SKELETON, SkeletonRenderer::new);

    private EntityRendererUtils() {
    }

    public static Function<EntityRendererProvider.Context, EntityRenderer<?, ?>> getVanillaRendererFactory(EntityType<?> entityType) {
        return VANILLA_RENDERER_FACTORIES.get(entityType);
    }

    public static EntityRenderer<?, ?> createFallbackRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        log.warn("No specific renderer found for entity type {}, using villager renderer as fallback", entityType);
        return new VillagerRenderer(context);
    }
}

