/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.HorseRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.HorseMarkingLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EquineRenderState;
import net.minecraft.client.renderer.entity.state.HorseRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;

public class HorseRawRenderer
extends AbstractHorseRenderer<Horse, HorseRenderState, HorseModel>
implements EasyNPCEntityRenderer {
    protected static final Map<HorseRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(HorseRaw.VariantType.class), map -> {
        map.put(HorseRaw.VariantType.WHITE, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_white.png"));
        map.put(HorseRaw.VariantType.WHITE_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_white.png"));
        map.put(HorseRaw.VariantType.CREAMY, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_creamy.png"));
        map.put(HorseRaw.VariantType.CREAMY_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_creamy.png"));
        map.put(HorseRaw.VariantType.CHESTNUT, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_chestnut.png"));
        map.put(HorseRaw.VariantType.CHESTNUT_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_chestnut.png"));
        map.put(HorseRaw.VariantType.BROWN, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_brown.png"));
        map.put(HorseRaw.VariantType.BROWN_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_brown.png"));
        map.put(HorseRaw.VariantType.BLACK, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_black.png"));
        map.put(HorseRaw.VariantType.BLACK_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_black.png"));
        map.put(HorseRaw.VariantType.GRAY, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_gray.png"));
        map.put(HorseRaw.VariantType.GRAY_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_gray.png"));
        map.put(HorseRaw.VariantType.DARKBROWN, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_darkbrown.png"));
        map.put(HorseRaw.VariantType.DARKBROWN_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_darkbrown.png"));
        map.put(HorseRaw.VariantType.ZOMBIE, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_zombie.png"));
        map.put(HorseRaw.VariantType.ZOMBIE_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_zombie.png"));
        map.put(HorseRaw.VariantType.SKELETON, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_skeleton.png"));
        map.put(HorseRaw.VariantType.SKELETON_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_skeleton.png"));
        map.put(HorseRaw.VariantType.DONKEY, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/donkey.png"));
        map.put(HorseRaw.VariantType.DONKEY_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/donkey.png"));
        map.put(HorseRaw.VariantType.MULE, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/mule.png"));
        map.put(HorseRaw.VariantType.MULE_SADDLED, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/mule.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)HorseRaw.VariantType.WHITE);

    public HorseRawRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HorseModel(context.bakeLayer(ModelLayers.HORSE)), (EntityModel)new HorseModel(context.bakeLayer(ModelLayers.HORSE_BABY)));
        this.addLayer((RenderLayer)new HorseMarkingLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new HorseArmorLayer((RenderLayerParent)this, context.getModelSet(), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(HorseRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    public HorseRenderState createRenderState() {
        return new HorseRenderState();
    }

    public void extractRenderState(Horse horse, HorseRenderState state, float partialTicks) {
        super.extractRenderState((AbstractHorse)horse, (EquineRenderState)state, partialTicks);
        state.variant = horse.getVariant();
        state.markings = horse.getMarkings();
        state.bodyArmorItem = horse.getBodyArmorItem().copy();
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

