/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface ProfessionDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String DATA_PROFESSION_TAG = "Profession";

    public static void registerSyncedProfessionData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Profession Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.PROFESSION, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.PROFESSION));
    }

    default public Profession getDefaultProfession() {
        return Profession.NONE;
    }

    default public Profession getProfession() {
        return (Profession)((Object)this.getSynchedEntityData(SynchedDataIndex.PROFESSION));
    }

    default public void setProfession(Profession profession) {
        this.setSynchedEntityData(SynchedDataIndex.PROFESSION, profession);
    }

    default public Profession getProfession(String name) {
        return Profession.valueOf(name);
    }

    default public boolean hasProfessions() {
        return false;
    }

    default public Profession[] getProfessions() {
        return Profession.values();
    }

    default public Component getProfessionName() {
        Profession profession = this.getProfession();
        return profession != null ? TextUtils.normalizeName(profession.name()) : TextComponent.getBlankText();
    }

    default public void defineSynchedProfessionData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.PROFESSION, this.getDefaultProfession());
    }

    default public void addAdditionalProfessionData(CompoundTag compoundTag) {
        if (this.getProfession() != null) {
            compoundTag.putString(DATA_PROFESSION_TAG, this.getProfession().name());
        }
    }

    default public void readAdditionalProfessionData(CompoundTag compoundTag) {
        String profession;
        if (compoundTag.contains(DATA_PROFESSION_TAG) && !(profession = compoundTag.getString(DATA_PROFESSION_TAG)).isEmpty()) {
            this.setProfession(this.getProfession(profession));
        }
    }
}

