/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.spawner;

import com.mojang.serialization.DynamicOps;
import de.markusbordihn.easynpc.config.SpawnerTypeConfig;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.SpawnData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerData {
    public static final String DELAY_TAG = "Delay";
    public static final String MIN_SPAWN_DELAY_TAG = "MinSpawnDelay";
    public static final String MAX_SPAWN_DELAY_TAG = "MaxSpawnDelay";
    public static final String SPAWN_COUNT_TAG = "SpawnCount";
    public static final String MAX_NEARBY_ENTITIES_TAG = "MaxNearbyEntities";
    public static final String REQUIRED_PLAYER_RANGE_TAG = "RequiredPlayerRange";
    public static final String SPAWN_RANGE_TAG = "SpawnRange";
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public static void setDelay(CompoundTag compoundTag, short spawnDelay) {
        compoundTag.putShort(DELAY_TAG, spawnDelay);
    }

    public static short getDelay(CompoundTag compoundTag) {
        return compoundTag.getShort(DELAY_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_DELAY);
    }

    public static void setMinSpawnDelay(CompoundTag compoundTag, short minSpawnDelay) {
        compoundTag.putShort(MIN_SPAWN_DELAY_TAG, minSpawnDelay);
    }

    public static short getMinSpawnDelay(CompoundTag compoundTag) {
        return compoundTag.getShort(MIN_SPAWN_DELAY_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_MIN_SPAWN_DELAY);
    }

    public static boolean hasMinSpawnDelay(CompoundTag compoundTag) {
        return compoundTag.contains(MIN_SPAWN_DELAY_TAG);
    }

    public static void setMaxSpawnDelay(CompoundTag compoundTag, short maxSpawnDelay) {
        compoundTag.putShort(MAX_SPAWN_DELAY_TAG, maxSpawnDelay);
    }

    public static short getMaxSpawnDelay(CompoundTag compoundTag) {
        return compoundTag.getShort(MAX_SPAWN_DELAY_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_MAX_SPAWN_DELAY);
    }

    public static void setSpawnCount(CompoundTag compoundTag, short spawnCount) {
        compoundTag.putShort(SPAWN_COUNT_TAG, spawnCount);
    }

    public static short getSpawnCount(CompoundTag compoundTag) {
        return compoundTag.getShort(SPAWN_COUNT_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_SPAWN_COUNT);
    }

    public static void setMaxNearbyEntities(CompoundTag compoundTag, short maxNearbyEntities) {
        compoundTag.putShort(MAX_NEARBY_ENTITIES_TAG, maxNearbyEntities);
    }

    public static short getMaxNearbyEntities(CompoundTag compoundTag) {
        return compoundTag.getShort(MAX_NEARBY_ENTITIES_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_MAX_NEARBY_ENTITIES);
    }

    public static boolean hasMaxNearbyEntities(CompoundTag compoundTag) {
        return compoundTag.contains(MAX_NEARBY_ENTITIES_TAG);
    }

    public static void setRequiredPlayerRange(CompoundTag compoundTag, short requiredPlayerRange) {
        compoundTag.putShort(REQUIRED_PLAYER_RANGE_TAG, requiredPlayerRange);
    }

    public static short getRequiredPlayerRange(CompoundTag compoundTag) {
        return compoundTag.getShort(REQUIRED_PLAYER_RANGE_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_REQUIRED_PLAYER_RANGE);
    }

    public static void setSpawnRange(CompoundTag compoundTag, short spawnRange) {
        compoundTag.putShort(SPAWN_RANGE_TAG, spawnRange);
    }

    public static short getSpawnRange(CompoundTag compoundTag) {
        return compoundTag.getShort(SPAWN_RANGE_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_SPAWN_RANGE);
    }

    public static boolean hasSpawnRange(CompoundTag compoundTag) {
        return compoundTag.contains(SPAWN_RANGE_TAG);
    }

    public static SpawnData getSpawnData(CompoundTag compoundTag) {
        if (!SpawnerData.hasSpawnData(compoundTag)) {
            return new SpawnData();
        }
        CompoundTag spawnData = compoundTag.getCompoundOrEmpty(SPAWN_DATA_TAG);
        return SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)spawnData).resultOrPartial(result -> log.warn("Invalid SpawnData: {}", result)).orElseGet(SpawnData::new);
    }

    public static boolean hasSpawnData(CompoundTag compoundTag) {
        return compoundTag.contains(SPAWN_DATA_TAG);
    }

    public static boolean setSpawnerValue(CompoundTag compoundTag, String parameter, short value) {
        switch (parameter) {
            case "Delay": {
                SpawnerData.setDelay(compoundTag, value);
                break;
            }
            case "MinSpawnDelay": {
                SpawnerData.setMinSpawnDelay(compoundTag, value);
                break;
            }
            case "MaxSpawnDelay": {
                SpawnerData.setMaxSpawnDelay(compoundTag, value);
                break;
            }
            case "SpawnCount": {
                SpawnerData.setSpawnCount(compoundTag, value);
                break;
            }
            case "MaxNearbyEntities": {
                SpawnerData.setMaxNearbyEntities(compoundTag, value);
                break;
            }
            case "RequiredPlayerRange": {
                SpawnerData.setRequiredPlayerRange(compoundTag, value);
                break;
            }
            case "SpawnRange": {
                SpawnerData.setSpawnRange(compoundTag, value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void setSpawnData(SpawnerType spawnerType, CompoundTag compoundTag) {
        switch (spawnerType) {
            case BOSS_SPAWNER: {
                SpawnerData.setDelay(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_DELAY);
                SpawnerData.setMinSpawnDelay(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_MIN_SPAWN_DELAY);
                SpawnerData.setMaxSpawnDelay(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_MAX_SPAWN_DELAY);
                SpawnerData.setSpawnCount(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_SPAWN_COUNT);
                SpawnerData.setMaxNearbyEntities(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_MAX_NEARBY_ENTITIES);
                SpawnerData.setRequiredPlayerRange(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_REQUIRED_PLAYER_RANGE);
                SpawnerData.setSpawnRange(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_SPAWN_RANGE);
                break;
            }
            case DEFAULT_SPAWNER: {
                SpawnerData.setDelay(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_DELAY);
                SpawnerData.setMinSpawnDelay(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_MIN_SPAWN_DELAY);
                SpawnerData.setMaxSpawnDelay(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_MAX_SPAWN_DELAY);
                SpawnerData.setSpawnCount(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_SPAWN_COUNT);
                SpawnerData.setMaxNearbyEntities(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_MAX_NEARBY_ENTITIES);
                SpawnerData.setRequiredPlayerRange(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_REQUIRED_PLAYER_RANGE);
                SpawnerData.setSpawnRange(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_SPAWN_RANGE);
                break;
            }
            case GROUP_SPAWNER: {
                SpawnerData.setDelay(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_DELAY);
                SpawnerData.setMinSpawnDelay(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_MIN_SPAWN_DELAY);
                SpawnerData.setMaxSpawnDelay(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_MAX_SPAWN_DELAY);
                SpawnerData.setSpawnCount(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_SPAWN_COUNT);
                SpawnerData.setMaxNearbyEntities(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_MAX_NEARBY_ENTITIES);
                SpawnerData.setRequiredPlayerRange(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_REQUIRED_PLAYER_RANGE);
                SpawnerData.setSpawnRange(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_SPAWN_RANGE);
                break;
            }
            case SINGLE_SPAWNER: {
                SpawnerData.setDelay(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_DELAY);
                SpawnerData.setMinSpawnDelay(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_MIN_SPAWN_DELAY);
                SpawnerData.setMaxSpawnDelay(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_MAX_SPAWN_DELAY);
                SpawnerData.setSpawnCount(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_SPAWN_COUNT);
                SpawnerData.setMaxNearbyEntities(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_MAX_NEARBY_ENTITIES);
                SpawnerData.setRequiredPlayerRange(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_REQUIRED_PLAYER_RANGE);
                SpawnerData.setSpawnRange(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_SPAWN_RANGE);
            }
        }
    }
}

