/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.client.pose.PoseManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.PoseSuggestions;
import de.markusbordihn.easynpc.data.animation.AnimationData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;

public class PoseCommand
extends Command {
    private PoseCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pose").requires(commandSource -> commandSource.hasPermission(0))).then(Commands.literal((String)"reset").then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PoseCommand.resetPose((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests(PoseSuggestions::suggest).then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> PoseCommand.setPose((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), ResourceLocationArgument.getId((CommandContext)context, (String)"type"))))));
    }

    private static int resetPose(CommandSourceStack context, EasyNPC<?> easyNPC) {
        PoseManager.resetModelPose(easyNPC);
        return PoseCommand.sendSuccessMessage(context, "Resetting pose for Easy NPC " + String.valueOf(easyNPC.getEntityUUID()) + " !");
    }

    private static int setPose(CommandSourceStack context, EasyNPC<?> easyNPC, ResourceLocation resourceLocation) {
        AnimationData.Animation animation = PoseManager.getPoseData(resourceLocation);
        if (animation == null) {
            return PoseCommand.sendFailureMessage(context, "Pose " + String.valueOf(resourceLocation) + " was not found!");
        }
        if (PoseManager.setModelPose(easyNPC, animation)) {
            return PoseCommand.sendSuccessMessage(context, "Setting pose " + String.valueOf(resourceLocation) + " for Easy NPC " + String.valueOf(easyNPC.getEntityUUID()) + " !");
        }
        return PoseCommand.sendFailureMessage(context, "Failed to set pose " + String.valueOf(resourceLocation) + " for Easy NPC " + String.valueOf(easyNPC.getEntityUUID()) + " !");
    }
}

