/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkinHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private SkinHandler() {
    }

    public static boolean setSkin(EasyNPC<?> easyNPC, SkinDataEntry skinDataEntry) {
        VariantDataCapable variantData;
        if (easyNPC == null || skinDataEntry == null) {
            log.error("Unable to set skin for {} with entry {}", easyNPC, (Object)skinDataEntry);
            return false;
        }
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.error("Unable to get skin data for {}", easyNPC);
            return false;
        }
        log.debug("[{}] Setting skin to {}", easyNPC, (Object)skinDataEntry);
        skinData.setSkinDataEntry(skinDataEntry);
        if (skinDataEntry.type() == SkinType.DEFAULT && !skinDataEntry.name().isEmpty() && (variantData = skinData.getEasyNPCVariantData()) != null) {
            variantData.setVariantType(skinDataEntry.name());
        }
        return true;
    }
}

