/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModSpawnEggItem
extends SpawnEggItem {
    public static final String SUFFIX = "_spawn_egg";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final Supplier<? extends EntityType<? extends Mob>> typeSupplier;

    public ModSpawnEggItem(EntityType<? extends Mob> entityType, Item.Properties properties) {
        this(() -> entityType, properties);
    }

    public ModSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> entityType, Item.Properties properties) {
        super(null, 0xFF5555, 0xFFFF55, properties);
        this.typeSupplier = entityType;
    }

    public Component getName(ItemStack itemStack) {
        String descriptionId = this.getDescriptionId();
        if (descriptionId.contains(SUFFIX)) {
            return TextComponent.getTranslatedTextRaw("item.easy_npc.spawn_egg", (Component)TextComponent.getTranslatedTextRaw(this.getDescriptionId().replace("item.easy_npc.", "entity.easy_npc.").replace(SUFFIX, "")));
        }
        return TextComponent.getTranslatedTextRaw(this.getDescriptionId());
    }

    public EntityType<?> getType(ItemStack itemStack) {
        EntityType<? extends Mob> type = super.getType(itemStack);
        return type != null ? type : this.typeSupplier.get();
    }

    public FeatureFlagSet requiredFeatures() {
        return this.typeSupplier.get().requiredFeatures();
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockState = level.getBlockState(blockPos);
        BlockPos blockPos1 = blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty() ? blockPos : blockPos.relative(direction);
        EntityType<?> entityType = this.getType(itemStack);
        Entity entity = entityType.spawn((ServerLevel)level, itemStack, context.getPlayer(), blockPos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, blockPos1) && direction == Direction.UP);
        if (entity != null) {
            if (entity instanceof EasyNPC) {
                OwnerDataCapable ownerData;
                EasyNPC easyNPC = (EasyNPC)entity;
                if (player != null && (ownerData = easyNPC.getEasyNPCOwnerData()) != null) {
                    ownerData.setNPCOwnerUUID(player.getUUID());
                }
            }
            itemStack.shrink(1);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockPos);
        }
        return InteractionResult.CONSUME;
    }
}

