/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class ScaleCommand
extends Command {
    private ScaleCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"scale").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).then(((RequiredArgumentBuilder)Commands.argument((String)"modelPart", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            EasyNPC<?> easyNPC = EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_targets");
            if (easyNPC != null) {
                ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
                for (ModelPartType partType : modelData.getModelType().getModelParts()) {
                    builder.suggest(partType.name().toLowerCase(Locale.ROOT));
                }
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).executes(context -> {
            String partString = StringArgumentType.getString((CommandContext)context, (String)"modelPart");
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"scale");
            ModelPartType modelPartType = ModelPartType.get(partString);
            if (modelPartType == ModelPartType.UNKNOWN) {
                return ScaleCommand.sendFailureMessage((CommandSourceStack)context.getSource(), "Invalid model part " + partString);
            }
            Collection<? extends EasyNPC<?>> easyNPCs = EasyNPCArgument.getEntitiesWithAccess((CommandContext<CommandSourceStack>)context, "npc_targets");
            return ScaleCommand.scaleModelPart((CommandSourceStack)context.getSource(), easyNPCs, modelPartType, new CustomScale(scale, scale, scale));
        }))).then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).then(Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).then(Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).executes(context -> {
            String partString = StringArgumentType.getString((CommandContext)context, (String)"modelPart");
            float x = FloatArgumentType.getFloat((CommandContext)context, (String)"x");
            float y = FloatArgumentType.getFloat((CommandContext)context, (String)"y");
            float z = FloatArgumentType.getFloat((CommandContext)context, (String)"z");
            ModelPartType modelPartType = ModelPartType.get(partString);
            if (modelPartType == ModelPartType.UNKNOWN) {
                return ScaleCommand.sendFailureMessage((CommandSourceStack)context.getSource(), "Invalid model part " + partString);
            }
            Collection<? extends EasyNPC<?>> easyNPCs = EasyNPCArgument.getEntitiesWithAccess((CommandContext<CommandSourceStack>)context, "npc_targets");
            return ScaleCommand.scaleModelPart((CommandSourceStack)context.getSource(), easyNPCs, modelPartType, new CustomScale(x, y, z));
        }))))));
    }

    private static int scaleModelPart(CommandSourceStack context, Collection<? extends EasyNPC<?>> easyNPCs, ModelPartType modelPartType, CustomScale scaling) {
        int scaled = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getEntityUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
                if (!modelData.getModelType().getModelParts().contains((Object)modelPartType)) {
                    ScaleCommand.sendFailureMessage(context, "Model part " + String.valueOf((Object)modelPartType) + " not supported by NPC " + String.valueOf(uuid) + ".");
                    continue;
                }
                modelData.setModelPartScale(modelPartType, scaling);
                modelData.setModelPose(modelData.hasChangedModel() ? ModelPose.CUSTOM : ModelPose.DEFAULT);
                ++scaled;
                continue;
            }
            ScaleCommand.sendFailureMessage(context, "You are not allowed to scale the Easy NPC " + String.valueOf(uuid) + " !");
        }
        return ScaleCommand.sendScalingFeedback(context, easyNPCs, scaled, modelPartType.name().toLowerCase(Locale.ROOT), scaling.x(), scaling.y(), scaling.z());
    }

    private static int sendScalingFeedback(CommandSourceStack context, Collection<? extends EasyNPC<?>> easyNPCs, int scaled, String partName, float x, float y, float z) {
        if (scaled == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return ScaleCommand.sendSuccessMessage(context, "Scaled model part '" + partName + "' of NPC " + easyNPC.getEntity().getDisplayName().getString() + " to x:" + x + ", y:" + y + ", z:" + z);
        }
        if (scaled > 1) {
            return ScaleCommand.sendSuccessMessage(context, "Scaled model part '" + partName + "' of " + scaled + " of " + easyNPCs.size() + " selected Easy NPCs to x:" + x + ", y:" + y + ", z:" + z);
        }
        return ScaleCommand.sendFailureMessage(context, "Nothing was scaled.");
    }
}

