/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.block.entity;

import de.markusbordihn.easynpc.block.EasyNPCSpawnerBlock;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EasyNPCSpawnerBlockEntity
extends BlockEntity {
    public static final String NAME = "easy_npc_spawner_entity";
    public static final String SPAWNER_OWNER_TAG = "Owner";
    public static final String UUID_TAG = "UUID";
    private final BaseEasyNPCSpawner spawner;
    private final SpawnerType spawnerType;
    private UUID owner;
    private UUID spawnerUUID;

    public EasyNPCSpawnerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        this(blockEntityType, blockPos, blockState, EasyNPCSpawnerBlock.getSpawnerType(blockState));
    }

    public EasyNPCSpawnerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, SpawnerType spawnerType) {
        super(blockEntityType, blockPos, blockState);
        this.spawnerType = spawnerType;
        this.spawner = new BaseEasyNPCSpawner(spawnerType);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, EasyNPCSpawnerBlockEntity blockEntity) {
        if (!blockEntity.spawner.hasEasyNPC()) {
            return;
        }
        blockEntity.spawner.m_151319_(level, blockPos);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, EasyNPCSpawnerBlockEntity blockEntity) {
        if (!blockEntity.spawner.hasEasyNPC()) {
            return;
        }
        blockEntity.spawner.m_151311_((ServerLevel)level, blockPos);
    }

    public SpawnerType getSpawnerType() {
        return this.spawnerType;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity livingEntity) {
        this.owner = livingEntity.m_20148_();
        this.m_6596_();
    }

    public UUID getSpawnerUUID() {
        return this.spawnerUUID;
    }

    public void setSpawnerUUID(UUID spawnerUUID) {
        this.spawnerUUID = spawnerUUID;
        this.m_6596_();
    }

    public void m_6596_() {
        super.m_6596_();
        this.spawner.updateSpawnData(this.spawner.m_186381_(new CompoundTag()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = this.m_187482_();
        compoundTag.m_128473_("SpawnPotentials");
        return compoundTag;
    }

    public boolean m_7531_(int id, int value) {
        return this.spawner.m_151316_(this.f_58857_, id) || super.m_7531_(id, value);
    }

    public BaseEasyNPCSpawner getSpawner() {
        return this.spawner;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.spawnerUUID = compoundTag.m_128441_(UUID_TAG) ? compoundTag.m_128342_(UUID_TAG) : UUID.randomUUID();
        this.owner = compoundTag.m_128441_(SPAWNER_OWNER_TAG) ? compoundTag.m_128342_(SPAWNER_OWNER_TAG) : null;
        this.spawner.m_151328_(this.f_58857_, this.f_58858_, compoundTag);
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128362_(UUID_TAG, Objects.requireNonNullElseGet(this.spawnerUUID, UUID::randomUUID));
        if (this.owner != null) {
            compoundTag.m_128362_(SPAWNER_OWNER_TAG, this.owner);
        }
        this.spawner.m_186381_(compoundTag);
    }
}

