/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.sound;

import de.markusbordihn.easynpc.data.sound.SoundDataEntry;
import de.markusbordihn.easynpc.data.sound.SoundType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SoundDataSet {
    public static final String DATA_SOUND_DATA_SET_TAG = "SoundDataSet";
    private final Map<SoundType, SoundDataEntry> defaultSounds = new EnumMap<SoundType, SoundDataEntry>(SoundType.class);
    private final Map<SoundType, SoundDataEntry> overrideSounds = new EnumMap<SoundType, SoundDataEntry>(SoundType.class);

    public SoundDataSet() {
    }

    public SoundDataSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public boolean hasSound(SoundType type) {
        return this.defaultSounds.containsKey((Object)type) || this.overrideSounds.containsKey((Object)type);
    }

    public void addSound(SoundType type, SoundEvent soundEvent) {
        this.addSound(type, soundEvent.m_11660_());
    }

    public void addSound(SoundType type, ResourceLocation resourceLocation) {
        if (resourceLocation == null || resourceLocation.toString().isEmpty()) {
            return;
        }
        if (this.defaultSounds.containsKey((Object)type) && this.defaultSounds.get((Object)type).getSoundEvent().m_11660_().equals((Object)resourceLocation)) {
            this.overrideSounds.remove((Object)type);
        } else {
            this.overrideSounds.put(type, new SoundDataEntry(type, resourceLocation));
        }
    }

    public void addDefaultSound(SoundType type, SoundEvent soundEvent) {
        if (soundEvent == null || soundEvent.m_11660_().toString().isEmpty()) {
            return;
        }
        this.defaultSounds.put(type, new SoundDataEntry(type, soundEvent.m_11660_()));
    }

    public boolean isEmpty() {
        return this.defaultSounds.isEmpty() && this.overrideSounds.isEmpty();
    }

    public SoundDataEntry getSound(SoundType type) {
        return this.overrideSounds.containsKey((Object)type) ? this.overrideSounds.get((Object)type) : this.defaultSounds.get((Object)type);
    }

    public void load(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_SOUND_DATA_SET_TAG)) {
            return;
        }
        this.overrideSounds.clear();
        ListTag soundListTag = compoundTag.m_128437_(DATA_SOUND_DATA_SET_TAG, 10);
        for (int i = 0; i < soundListTag.size(); ++i) {
            CompoundTag soundDataTag = soundListTag.m_128728_(i);
            SoundDataEntry soundDataEntry = new SoundDataEntry(soundDataTag);
            SoundType type = soundDataEntry.getType();
            SoundEvent event = soundDataEntry.getSoundEvent();
            if (type == null || event == null || this.defaultSounds.containsKey((Object)type) && this.defaultSounds.get((Object)type).getSoundEvent().equals(event)) continue;
            this.overrideSounds.put(type, soundDataEntry);
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        ListTag soundListTag = new ListTag();
        for (Map.Entry<SoundType, SoundDataEntry> entry : this.overrideSounds.entrySet()) {
            SoundDataEntry soundDataEntry = entry.getValue();
            soundListTag.add((Object)soundDataEntry.createTag());
        }
        compoundTag.m_128365_(DATA_SOUND_DATA_SET_TAG, (Tag)soundListTag);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }
}

