/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.syncher;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.trading.MerchantOffers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDataSerializersManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<String, EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = new LinkedHashMap();
    public static final EntityDataSerializer<ActionEventSet> ACTION_EVENT_SET = EntityDataSerializersManager.defineSerializer(ActionEventSet.class.getSimpleName(), new EntityDataSerializer<ActionEventSet>(){

        public void write(FriendlyByteBuf buffer, ActionEventSet value) {
            buffer.m_130079_(value.createTag());
        }

        public ActionEventSet read(FriendlyByteBuf buffer) {
            return new ActionEventSet(buffer.m_130260_());
        }

        public ActionEventSet copy(ActionEventSet value) {
            return value;
        }
    });
    public static final EntityDataSerializer<DialogDataSet> DIALOG_DATA_SET = EntityDataSerializersManager.defineSerializer(DialogDataSet.class.getSimpleName(), new EntityDataSerializer<DialogDataSet>(){

        public void write(FriendlyByteBuf buffer, DialogDataSet value) {
            buffer.m_130079_(value.createTag());
        }

        public DialogDataSet read(FriendlyByteBuf buffer) {
            return new DialogDataSet(buffer.m_130260_());
        }

        public DialogDataSet copy(DialogDataSet value) {
            return value;
        }
    });
    public static final EntityDataSerializer<EnumMap<DisplayAttributeType, DisplayAttributeEntry>> DISPLAY_ATTRIBUTE = EntityDataSerializersManager.defineSerializer(DisplayAttributeType.class.getSimpleName() + ":DisplayAttribute", new EntityDataSerializer<EnumMap<DisplayAttributeType, DisplayAttributeEntry>>(){

        public void write(FriendlyByteBuf buffer, EnumMap<DisplayAttributeType, DisplayAttributeEntry> value) {
            buffer.m_130130_(value.size());
            for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : value.entrySet()) {
                buffer.m_130068_((Enum)entry.getKey());
                buffer.m_130079_(entry.getValue().createTag());
            }
        }

        public EnumMap<DisplayAttributeType, DisplayAttributeEntry> read(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            EnumMap<DisplayAttributeType, DisplayAttributeEntry> value = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
            for (int i = 0; i < size; ++i) {
                DisplayAttributeType type = (DisplayAttributeType)buffer.m_130066_(DisplayAttributeType.class);
                CompoundTag nbt = buffer.m_130260_();
                if (nbt == null) continue;
                DisplayAttributeEntry entry = new DisplayAttributeEntry(nbt);
                value.put(type, entry);
            }
            return value;
        }

        public EnumMap<DisplayAttributeType, DisplayAttributeEntry> copy(EnumMap<DisplayAttributeType, DisplayAttributeEntry> value) {
            return new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(value);
        }
    });
    public static final EntityDataSerializer<EntityAttributes> ENTITY_ATTRIBUTES = EntityDataSerializersManager.defineSerializer(EntityAttributes.class.getSimpleName(), new EntityDataSerializer<EntityAttributes>(){

        public void write(FriendlyByteBuf buffer, EntityAttributes value) {
            buffer.m_130079_(value.createTag());
        }

        public EntityAttributes read(FriendlyByteBuf buffer) {
            return new EntityAttributes(buffer.m_130260_());
        }

        public EntityAttributes copy(EntityAttributes value) {
            return value;
        }
    });
    public static final EntityDataSerializer<MerchantOffers> MERCHANT_OFFERS = EntityDataSerializersManager.defineSerializer(MerchantOffers.class.getSimpleName(), new EntityDataSerializer<MerchantOffers>(){

        public void write(FriendlyByteBuf buffer, MerchantOffers value) {
            buffer.m_130079_(value.m_45388_());
        }

        public MerchantOffers read(FriendlyByteBuf buffer) {
            CompoundTag compoundTag = buffer.m_130260_();
            return compoundTag != null ? new MerchantOffers(compoundTag) : new MerchantOffers();
        }

        public MerchantOffers copy(MerchantOffers value) {
            return value;
        }
    });
    public static final EntityDataSerializer<ModelPose> MODEL_POSE = EntityDataSerializersManager.defineSerializer(ModelPose.class.getSimpleName(), new EntityDataSerializer<ModelPose>(){

        public void write(FriendlyByteBuf buffer, ModelPose modelPose) {
            buffer.m_130068_((Enum)modelPose);
        }

        public ModelPose read(FriendlyByteBuf buffer) {
            return (ModelPose)buffer.m_130066_(ModelPose.class);
        }

        public ModelPose copy(ModelPose value) {
            return value;
        }
    });
    public static final EntityDataSerializer<ObjectiveDataSet> OBJECTIVE_DATA_SET = EntityDataSerializersManager.defineSerializer(ObjectiveDataSet.class.getSimpleName(), new EntityDataSerializer<ObjectiveDataSet>(){

        public void write(FriendlyByteBuf buffer, ObjectiveDataSet value) {
            buffer.m_130079_(value.createTag());
        }

        public ObjectiveDataSet read(FriendlyByteBuf buffer) {
            return new ObjectiveDataSet(buffer.m_130260_());
        }

        public ObjectiveDataSet copy(ObjectiveDataSet value) {
            return value;
        }
    });
    public static final EntityDataSerializer<Profession> PROFESSION = EntityDataSerializersManager.defineSerializer(Profession.class.getSimpleName(), new EntityDataSerializer<Profession>(){

        public void write(FriendlyByteBuf buffer, Profession value) {
            buffer.m_130068_((Enum)value);
        }

        public Profession read(FriendlyByteBuf buffer) {
            return (Profession)buffer.m_130066_(Profession.class);
        }

        public Profession copy(Profession value) {
            return value;
        }
    });
    public static final EntityDataSerializer<RenderDataSet> RENDER_DATA_SET = EntityDataSerializersManager.defineSerializer(RenderDataSet.class.getSimpleName(), new EntityDataSerializer<RenderDataSet>(){

        public void write(FriendlyByteBuf buffer, RenderDataSet value) {
            buffer.m_130079_(value.createTag());
        }

        public RenderDataSet read(FriendlyByteBuf buffer) {
            return new RenderDataSet(buffer.m_130260_());
        }

        public RenderDataSet copy(RenderDataSet value) {
            return value;
        }
    });
    public static final EntityDataSerializer<Map<ModelPartType, CustomRotation>> MODEL_PART_ROTATION = EntityDataSerializersManager.defineSerializer(ModelPartType.class.getSimpleName() + ":CustomRotation", new EntityDataSerializer<Map<ModelPartType, CustomRotation>>(){

        public void write(FriendlyByteBuf buffer, Map<ModelPartType, CustomRotation> value) {
            buffer.m_130130_(value.size());
            for (Map.Entry<ModelPartType, CustomRotation> entry : value.entrySet()) {
                buffer.m_130068_((Enum)entry.getKey());
                entry.getValue().encode(buffer);
            }
        }

        public Map<ModelPartType, CustomRotation> read(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            EnumMap<ModelPartType, CustomRotation> value = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
            for (int i = 0; i < size; ++i) {
                value.put((ModelPartType)buffer.m_130066_(ModelPartType.class), CustomRotation.decode(buffer));
            }
            return value;
        }

        public Map<ModelPartType, CustomRotation> copy(Map<ModelPartType, CustomRotation> value) {
            return new EnumMap<ModelPartType, CustomRotation>(value);
        }
    });
    public static final EntityDataSerializer<Map<ModelPartType, CustomPosition>> MODEL_PART_POSITION = EntityDataSerializersManager.defineSerializer(ModelPartType.class.getSimpleName() + ":CustomPosition", new EntityDataSerializer<Map<ModelPartType, CustomPosition>>(){

        public void write(FriendlyByteBuf buffer, Map<ModelPartType, CustomPosition> value) {
            buffer.m_130130_(value.size());
            for (Map.Entry<ModelPartType, CustomPosition> entry : value.entrySet()) {
                buffer.m_130068_((Enum)entry.getKey());
                entry.getValue().encode(buffer);
            }
        }

        public Map<ModelPartType, CustomPosition> read(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            EnumMap<ModelPartType, CustomPosition> value = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
            for (int i = 0; i < size; ++i) {
                value.put((ModelPartType)buffer.m_130066_(ModelPartType.class), CustomPosition.decode(buffer));
            }
            return value;
        }

        public Map<ModelPartType, CustomPosition> copy(Map<ModelPartType, CustomPosition> value) {
            return new EnumMap<ModelPartType, CustomPosition>(value);
        }
    });
    public static final EntityDataSerializer<Map<ModelPartType, CustomScale>> MODEL_PART_SCALE = EntityDataSerializersManager.defineSerializer(ModelPartType.class.getSimpleName() + ":CustomScale", new EntityDataSerializer<Map<ModelPartType, CustomScale>>(){

        public void write(FriendlyByteBuf buffer, Map<ModelPartType, CustomScale> value) {
            buffer.m_130130_(value.size());
            for (Map.Entry<ModelPartType, CustomScale> entry : value.entrySet()) {
                buffer.m_130068_((Enum)entry.getKey());
                entry.getValue().encode(buffer);
            }
        }

        public Map<ModelPartType, CustomScale> read(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            EnumMap<ModelPartType, CustomScale> value = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
            for (int i = 0; i < size; ++i) {
                value.put((ModelPartType)buffer.m_130066_(ModelPartType.class), CustomScale.decode(buffer));
            }
            return value;
        }

        public Map<ModelPartType, CustomScale> copy(Map<ModelPartType, CustomScale> value) {
            return new EnumMap<ModelPartType, CustomScale>(value);
        }
    });
    public static final EntityDataSerializer<Map<ModelPartType, Boolean>> MODEL_PART_VISIBILITY = EntityDataSerializersManager.defineSerializer(ModelPartType.class.getSimpleName() + ":Visibility", new EntityDataSerializer<Map<ModelPartType, Boolean>>(){

        public void write(FriendlyByteBuf buffer, Map<ModelPartType, Boolean> value) {
            buffer.m_130130_(value.size());
            for (Map.Entry<ModelPartType, Boolean> entry : value.entrySet()) {
                buffer.m_130068_((Enum)entry.getKey());
                buffer.writeBoolean(entry.getValue().booleanValue());
            }
        }

        public Map<ModelPartType, Boolean> read(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            EnumMap<ModelPartType, Boolean> value = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
            for (int i = 0; i < size; ++i) {
                value.put((ModelPartType)buffer.m_130066_(ModelPartType.class), buffer.readBoolean());
            }
            return value;
        }

        public Map<ModelPartType, Boolean> copy(Map<ModelPartType, Boolean> value) {
            return new EnumMap<ModelPartType, Boolean>(value);
        }
    });
    public static final EntityDataSerializer<SkinDataEntry> SKIN_DATA_ENTRY = EntityDataSerializersManager.defineSerializer(SkinDataEntry.class.getSimpleName(), new EntityDataSerializer<SkinDataEntry>(){

        public void write(FriendlyByteBuf buffer, SkinDataEntry value) {
            buffer.m_130079_(value.createTag());
        }

        public SkinDataEntry read(FriendlyByteBuf buffer) {
            return new SkinDataEntry(buffer.m_130260_());
        }

        public SkinDataEntry copy(SkinDataEntry value) {
            return value;
        }
    });
    public static final EntityDataSerializer<SoundDataSet> SOUND_DATA_SET = EntityDataSerializersManager.defineSerializer(SoundDataSet.class.getSimpleName(), new EntityDataSerializer<SoundDataSet>(){

        public void write(FriendlyByteBuf buffer, SoundDataSet value) {
            buffer.m_130079_(value.createTag());
        }

        public SoundDataSet read(FriendlyByteBuf buffer) {
            return new SoundDataSet(buffer.m_130260_());
        }

        public SoundDataSet copy(SoundDataSet value) {
            return value;
        }
    });
    public static final EntityDataSerializer<HashSet<UUID>> TARGETED_ENTITY_HASH_SET = EntityDataSerializersManager.defineSerializer(HashSet.class.getSimpleName() + ":" + UUID.class.getSimpleName(), new EntityDataSerializer<HashSet<UUID>>(){

        public void write(FriendlyByteBuf buffer, HashSet<UUID> value) {
            for (UUID entry : value) {
                buffer.m_130077_(entry);
            }
        }

        public HashSet<UUID> read(FriendlyByteBuf buffer) {
            HashSet<UUID> value = new HashSet<UUID>();
            while (buffer.isReadable()) {
                value.add(buffer.m_130259_());
            }
            return value;
        }

        public HashSet<UUID> copy(HashSet<UUID> value) {
            return value;
        }
    });
    public static final EntityDataSerializer<HashSet<String>> TARGETED_PLAYER_HASH_SET = EntityDataSerializersManager.defineSerializer(HashSet.class.getSimpleName() + ":" + String.class.getSimpleName(), new EntityDataSerializer<HashSet<String>>(){

        public void write(FriendlyByteBuf buffer, HashSet<String> value) {
            for (String entry : value) {
                buffer.m_130070_(entry);
            }
        }

        public HashSet<String> read(FriendlyByteBuf buffer) {
            HashSet<String> value = new HashSet<String>();
            while (buffer.isReadable()) {
                value.add(buffer.m_130277_());
            }
            return value;
        }

        public HashSet<String> copy(HashSet<String> value) {
            return value;
        }
    });
    public static final EntityDataSerializer<TradingDataSet> TRADING_DATA_SET = EntityDataSerializersManager.defineSerializer(TradingDataSet.class.getSimpleName(), new EntityDataSerializer<TradingDataSet>(){

        public void write(FriendlyByteBuf buffer, TradingDataSet value) {
            buffer.m_130079_(value.createTag());
        }

        public TradingDataSet read(FriendlyByteBuf buffer) {
            return new TradingDataSet(buffer.m_130260_());
        }

        public TradingDataSet copy(TradingDataSet value) {
            return value;
        }
    });
    public static final EntityDataSerializer<UUID> UUID = EntityDataSerializersManager.defineSerializer(UUID.class.getSimpleName(), new EntityDataSerializer<UUID>(){

        public void write(FriendlyByteBuf buffer, UUID value) {
            buffer.m_130077_(value);
        }

        public UUID read(FriendlyByteBuf buffer) {
            return buffer.m_130259_();
        }

        public UUID copy(UUID value) {
            return value;
        }
    });

    private EntityDataSerializersManager() {
    }

    public static <T> EntityDataSerializer<T> defineSerializer(String className, EntityDataSerializer<T> serializer) {
        if (ENTITY_DATA_SERIALIZERS.containsKey(className)) {
            log.error("Entity data serializer {} already defined with {}!", (Object)className, ENTITY_DATA_SERIALIZERS.get(className));
            return null;
        }
        ENTITY_DATA_SERIALIZERS.put(className, serializer);
        return serializer;
    }

    public static void register() {
        for (Map.Entry<String, EntityDataSerializer<?>> entry : ENTITY_DATA_SERIALIZERS.entrySet()) {
            EntityDataSerializer<?> serializer = entry.getValue();
            if (serializer == null) {
                log.error("Failed to register entity data serializer {}", (Object)entry.getKey());
                continue;
            }
            EntityDataSerializers.m_135050_(serializer);
            int id = EntityDataSerializers.m_135052_(serializer);
            if (id >= 0) {
                log.info("Registered entity data serializer {} with id {}", (Object)entry.getKey(), (Object)id);
                continue;
            }
            log.error("Failed to register entity data serializer {} with {}", (Object)entry.getKey(), serializer);
        }
    }
}

