/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands.objectives;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveGroup;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class FollowObjective
extends Command {
    private static final String OBJECTIVE_NAME = "follow";

    private FollowObjective() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> registerSet() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)OBJECTIVE_NAME).then(Commands.m_82127_((String)ObjectiveType.FOLLOW_OWNER.getFriendlyName()).executes(context -> FollowObjective.setFollowOwner((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"))))).then(Commands.m_82127_((String)ObjectiveType.FOLLOW_PLAYER.getFriendlyName()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> FollowObjective.setFollowPlayer((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)ObjectiveType.FOLLOW_ENTITY_BY_UUID.getFriendlyName()).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> FollowObjective.setFollowEntity((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EntityArgument.m_91452_((CommandContext)context, (String)"entity")))));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> registerList() {
        return Commands.m_82127_((String)OBJECTIVE_NAME).executes(context -> FollowObjective.list((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target")));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> registerRemove() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)OBJECTIVE_NAME).then(Commands.m_82127_((String)ObjectiveType.FOLLOW_OWNER.getFriendlyName()).executes(context -> FollowObjective.removeFollowObjective((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), ObjectiveType.FOLLOW_OWNER)))).then(Commands.m_82127_((String)ObjectiveType.FOLLOW_PLAYER.getFriendlyName()).executes(context -> FollowObjective.removeFollowObjective((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), ObjectiveType.FOLLOW_PLAYER)))).then(Commands.m_82127_((String)ObjectiveType.FOLLOW_ENTITY_BY_UUID.getFriendlyName()).executes(context -> FollowObjective.removeFollowObjective((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), ObjectiveType.FOLLOW_ENTITY_BY_UUID)));
    }

    public static int removeFollowObjective(CommandSourceStack context, EasyNPC<?> easyNPC, ObjectiveType objectiveType) {
        ObjectiveDataCapable<?> objectiveData = FollowObjective.getFollowObjectiveData(context, easyNPC);
        if (objectiveData == null || objectiveType == null) {
            return 0;
        }
        if (!objectiveData.removeCustomObjective(objectiveType)) {
            return FollowObjective.sendFailureMessage(context, "Error removing follow objective " + String.valueOf((Object)objectiveType) + " for " + String.valueOf(easyNPC));
        }
        return FollowObjective.sendSuccessMessage(context, "Removed follow objective " + String.valueOf((Object)objectiveType) + " for " + String.valueOf(easyNPC));
    }

    public static int list(CommandSourceStack context, EasyNPC<?> easyNPC) {
        ObjectiveDataCapable<?> objectiveData = FollowObjective.getFollowObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return 0;
        }
        FollowObjective.sendSuccessMessage(context, "Follow objectives for " + String.valueOf(easyNPC) + ":");
        objectiveData.getObjectiveEntry(ObjectiveType.FOLLOW_OWNER).ifPresent(objective -> FollowObjective.sendSuccessMessage(context, "> " + String.valueOf((Object)objective.getType()) + ": " + String.valueOf(objective.getTargetOwnerUUID())));
        objectiveData.getObjectiveEntry(ObjectiveType.FOLLOW_PLAYER).ifPresent(objective -> FollowObjective.sendSuccessMessage(context, "> " + String.valueOf((Object)objective.getType()) + ": " + objective.getTargetPlayerName()));
        objectiveData.getObjectiveEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID).ifPresent(objective -> FollowObjective.sendSuccessMessage(context, "> " + String.valueOf((Object)objective.getType()) + ": " + String.valueOf(objective.getTargetEntityUUID())));
        return 1;
    }

    public static int setFollowOwner(CommandSourceStack context, EasyNPC<?> easyNPC) {
        ObjectiveDataCapable<?> objectiveData = FollowObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return 0;
        }
        OwnerDataCapable ownerData = easyNPC.getEasyNPCOwnerData();
        if (ownerData == null || !ownerData.hasNPCOwner() || ownerData.m_21805_() == null) {
            return FollowObjective.sendFailureMessageNoOwnerData(context, easyNPC);
        }
        ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_OWNER);
        objectiveDataEntry.setTargetOwnerUUID(ownerData.m_21805_());
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            return FollowObjective.sendFailureMessage(context, "Error adding or updating follow owner objective!");
        }
        return FollowObjective.sendSuccessMessage(context, "Follow owner objective added for " + String.valueOf(easyNPC));
    }

    public static int setFollowPlayer(CommandSourceStack context, EasyNPC<?> easyNPC, ServerPlayer serverPlayer) {
        ObjectiveDataCapable<?> objectiveData = FollowObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null || serverPlayer == null) {
            return 0;
        }
        ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_PLAYER);
        objectiveDataEntry.setTargetPlayerName(serverPlayer.m_7755_().getString());
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            return FollowObjective.sendFailureMessage(context, "Error adding or updating follow player objective!");
        }
        return FollowObjective.sendSuccessMessage(context, "Follow player " + serverPlayer.m_7755_().getString() + " objective added for " + String.valueOf(easyNPC));
    }

    public static int setFollowEntity(CommandSourceStack context, EasyNPC<?> easyNPC, Entity entity) {
        ObjectiveDataCapable<?> objectiveData = FollowObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null || entity == null) {
            return 0;
        }
        if (entity.m_20148_().equals(easyNPC.getEntityUUID())) {
            return FollowObjective.sendFailureMessage(context, "Error adding follow entity objective for itself!");
        }
        ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID);
        objectiveDataEntry.setTargetEntityUUID(entity.m_20148_());
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            return FollowObjective.sendFailureMessage(context, "Error adding or updating follow player objective!");
        }
        return FollowObjective.sendSuccessMessage(context, "Follow entity " + entity.m_7755_().getString() + " objective added for " + String.valueOf(easyNPC));
    }

    private static ObjectiveDataCapable<?> getObjectiveData(CommandSourceStack context, EasyNPC<?> easyNPC) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null || !objectiveData.hasObjectives()) {
            FollowObjective.sendFailureMessageNoObjectiveData(context, easyNPC);
            return null;
        }
        return objectiveData;
    }

    private static ObjectiveDataCapable<?> getFollowObjectiveData(CommandSourceStack context, EasyNPC<?> easyNPC) {
        ObjectiveDataCapable<?> objectiveData = FollowObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return null;
        }
        if (!objectiveData.hasObjectives(ObjectiveGroup.FOLLOW)) {
            FollowObjective.sendFailureMessageNoObjectiveData(context, easyNPC, OBJECTIVE_NAME);
            return null;
        }
        return objectiveData;
    }
}

