/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.model.custom.DopplerModel;
import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.skin.variant.DopplerSkinVariant;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DopplerRenderer<E extends PathfinderMob>
extends HumanoidMobRenderer<E, DopplerModel<E>>
implements EasyNPCEntityRenderer {
    protected static final ResourceLocation DEFAULT_TEXTURE = DopplerSkinVariant.DOPPLER.getTextureLocation();
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public DopplerRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, new DopplerModel(context.bakeLayer(modelLayerLocation)), 0.5f);
    }

    private boolean renderEntity(PathfinderMob entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null || renderData.getRenderDataSet() == null || renderData.getRenderDataSet().getRenderType() != RenderType.CUSTOM_ENTITY) {
            return false;
        }
        EntityType<? extends Entity> renderEntityType = renderData.getRenderDataSet().getRenderEntityType();
        PathfinderMob customEntity = EntityTypeManager.getPathfinderMob(renderEntityType, entity.level());
        if (customEntity == null) {
            return false;
        }
        String entityTypeName = EntityTypeManager.getEntityTypeName(renderEntityType);
        LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> livingEntityRenderer = RendererManager.getLivingEntityRenderer(renderEntityType, customEntity);
        if (livingEntityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity, (LivingEntity)customEntity, entityTypeName);
                livingEntityRenderer.render((LivingEntity)customEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom living entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        EntityRenderer<? extends Entity> entityRenderer = RendererManager.getEntityRenderer(renderEntityType, customEntity);
        if (entityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity, (LivingEntity)customEntity, entityTypeName);
                entityRenderer.render((Entity)customEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        return false;
    }

    public ResourceLocation getTextureLocation(E entity) {
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    public void render(E entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (this.renderEntity((PathfinderMob)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight)) {
            return;
        }
        super.render(entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }
}

