/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.action.ActionGroup;
import de.markusbordihn.easynpc.data.action.ActionManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface ActionHandler<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final Set<String> BLOCKED_UNSAFE_NPC_COMMANDS = new HashSet<String>(List.of("ban-ip", "ban", "banlist", "debug", "deop", "difficulty", "forceload", "gamerule", "kick", "op", "pardon", "reload", "save-all", "save-off", "save-on", "setidletimeout", "setworldspawn", "stop", "whitelist"));

    private static boolean isBlockedUnsafeNPCCommand(String command) {
        String[] runParts;
        String relevant;
        if (command == null || command.isBlank()) {
            return false;
        }
        String cmd = command.trim();
        if (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        if ((relevant = (runParts = cmd.split("\\s+run\\s+"))[runParts.length - 1].trim()).startsWith("/")) {
            relevant = relevant.substring(1);
        }
        String mainCmd = relevant.split(" ")[0].toLowerCase(Locale.ROOT);
        return BLOCKED_UNSAFE_NPC_COMMANDS.contains(mainCmd);
    }

    private static boolean validateActionData(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        return actionDataEntry != null && serverPlayer != null && actionDataEntry.isValidAndNotEmpty() && !serverPlayer.level().isClientSide();
    }

    public static void executeEntityCommand(String command, Entity entity, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = entity.getServer();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for entity {}", (Object)entity);
            return;
        }
        if (ActionHandler.isBlockedUnsafeNPCCommand(command)) {
            log.warn("Blocked unsafe entity command {} for {} with permission level {}!", (Object)command, (Object)entity, (Object)permissionLevel);
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Entity {} Command: \"{}\" with permission level {}", (Object)entity, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.getCommands();
        CommandSourceStack commandSourceStack = minecraftServer.createCommandSourceStack().withEntity(entity).withPosition(entity.position()).withRotation(entity.getRotationVector()).withPermission(permissionLevel);
        CommandDispatcher commandDispatcher = commands.getDispatcher();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.withSuppressedOutput()));
        commands.performCommand(parseResults, command);
    }

    public static void executePlayerCommand(String command, ServerPlayer serverPlayer, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = serverPlayer.getServer();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for player {}", (Object)serverPlayer);
            return;
        }
        if (ActionHandler.isBlockedUnsafeNPCCommand(command)) {
            log.warn("Blocked unsafe player command {} for {} with permission level {}!", (Object)command, (Object)serverPlayer, (Object)permissionLevel);
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Player {} Command: \"{}\" with permission level {}", (Object)serverPlayer, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.getCommands();
        CommandSourceStack commandSourceStack = minecraftServer.createCommandSourceStack().withEntity((Entity)serverPlayer).withPosition(serverPlayer.position()).withRotation(serverPlayer.getRotationVector()).withPermission(permissionLevel).withLevel(serverPlayer.serverLevel());
        CommandDispatcher commandDispatcher = commands.getDispatcher();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.withSuppressedOutput()));
        commands.performCommand(parseResults, command);
    }

    default public List<? extends Player> getPlayersInRange(Double range) {
        Entity entity = this.getEntity();
        return this.getEntityLevel().players().stream().filter(EntitySelector.NO_SPECTATORS).filter(targetPlayers -> entity.closerThan((Entity)targetPlayers, range.doubleValue())).toList();
    }

    default public void checkTradingActions() {
        this.getProfiler().push("npcCheckTradingActions");
        TradingDataCapable tradingData = this.getEasyNPCTradingData();
        TickerDataCapable tickerData = this.getEasyNPCTickerData();
        if (tradingData == null || tickerData == null) {
            return;
        }
        this.getProfiler().pop();
    }

    default public void checkDistanceActions() {
        ServerPlayer serverPlayer;
        ActionDataEntry actionDataEntry;
        List<Player> listOfPlayers;
        this.getProfiler().push("npcCheckDistanceActions");
        Mob mob = this.getMob();
        ActionEventDataCapable actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null || mob == null || mob.isDeadOrDying()) {
            return;
        }
        boolean skipPlayerDistanceCheck = false;
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_NEAR)) {
            listOfPlayers = this.getPlayersInRange(16.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_NEAR);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_NEAR);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_CLOSE)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(8.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_CLOSE);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(4.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_VERY_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_TOUCH)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(1.25);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_TOUCH);
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_TOUCH);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer);
                }
            }
        }
        this.getProfiler().pop();
    }

    default public void interactWithBlock(BlockPos blockPos) {
        LivingEntity livingEntity = this.getLivingEntity();
        if (livingEntity != null && !this.isClientSideInstance()) {
            this.lookAtBlock(blockPos);
            livingEntity.swing(InteractionHand.MAIN_HAND);
            if (!livingEntity.getMainHandItem().isEmpty()) {
                this.getEntityServerLevel().getBlockState(blockPos).useItemOn(livingEntity.getMainHandItem(), (Level)this.getEntityServerLevel(), (Player)this.getFakePlayer(this.getEntityServerLevel(), blockPos), InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.atCenterOf((Vec3i)blockPos), Direction.DOWN, blockPos, false));
            } else {
                this.getEntityServerLevel().getBlockState(blockPos).useWithoutItem((Level)this.getEntityServerLevel(), (Player)this.getFakePlayer(this.getEntityServerLevel(), blockPos), new BlockHitResult(Vec3.atCenterOf((Vec3i)blockPos), Direction.DOWN, blockPos, false));
            }
            livingEntity.getMainHandItem().use((Level)this.getEntityServerLevel(), (Player)this.getFakePlayer(this.getEntityServerLevel(), blockPos), InteractionHand.MAIN_HAND);
        }
    }

    default public void lookAtBlock(BlockPos target) {
        Entity entity = this.getEntity();
        Vec3 vec3d = entity.position();
        Vec3 targetVec = Vec3.atCenterOf((Vec3i)target);
        Vec3 delta = targetVec.subtract(vec3d);
        double horizontalDistance = delta.horizontalDistance();
        entity.setXRot(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)delta.y, (double)horizontalDistance) * 57.29577951308232)))));
        entity.setYBodyRot(Mth.wrapDegrees((float)((float)(Mth.atan2((double)delta.z, (double)delta.x) * 57.29577951308232) - 90.0f)));
        entity.setYHeadRot(entity.getYHeadRot());
    }

    default public void executeActions(ActionDataSet actionDataSet, ServerPlayer serverPlayer) {
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            return;
        }
        ActionDataEntry closeDialogAction = null;
        boolean hasScreenAction = false;
        for (ActionDataEntry actionDataEntry : actionDataSet.getEntries()) {
            ActionDataType actionType = actionDataEntry.actionDataType();
            if (actionType == ActionDataType.CLOSE_DIALOG) {
                if (closeDialogAction == null) {
                    closeDialogAction = actionDataEntry;
                    continue;
                }
                log.warn("Multiple close dialog actions found in action data set {}!", (Object)actionDataSet);
                continue;
            }
            if (actionType == ActionDataType.OPEN_DEFAULT_DIALOG || actionType == ActionDataType.OPEN_NAMED_DIALOG || actionType == ActionDataType.OPEN_TRADING_SCREEN) {
                if (hasScreenAction) {
                    log.debug("Ignoring {}. Multiple screen actions found in action data set {}! Only the first valid will be executed.", (Object)actionType, (Object)actionDataSet);
                    continue;
                }
                if (actionType == ActionDataType.OPEN_DEFAULT_DIALOG && !this.getEasyNPCDialogData().hasDialog() || actionType == ActionDataType.OPEN_NAMED_DIALOG && !this.getEasyNPCDialogData().hasDialog(actionDataEntry.command()) || actionType == ActionDataType.OPEN_TRADING_SCREEN && !this.getEasyNPCTradingData().hasTradingData()) {
                    log.debug("Ignoring {} action because no data is available.", (Object)actionType);
                    continue;
                }
                hasScreenAction = true;
            }
            this.executeAction(actionDataEntry, serverPlayer);
        }
        if (closeDialogAction != null) {
            this.executeAction(closeDialogAction, serverPlayer);
        }
    }

    default public void executeAction(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        switch (actionDataEntry.actionDataType()) {
            case NONE: {
                break;
            }
            case COMMAND: {
                if (actionDataEntry.executeAsUser()) {
                    this.executePlayerCommand(actionDataEntry, serverPlayer);
                    break;
                }
                this.executeEntityCommand(actionDataEntry, serverPlayer);
                break;
            }
            case CLOSE_DIALOG: {
                serverPlayer.closeContainer();
                break;
            }
            case INTERACT_BLOCK: {
                BlockPos blockPos = actionDataEntry.blockPos();
                if (blockPos != null && !blockPos.equals((Object)BlockPos.ZERO)) {
                    this.interactWithBlock(blockPos);
                    break;
                }
                log.error("No block position found for action {}", (Object)actionDataEntry);
                break;
            }
            case OPEN_DEFAULT_DIALOG: {
                this.openDefaultDialog(actionDataEntry, serverPlayer);
                break;
            }
            case OPEN_NAMED_DIALOG: {
                this.openNamedDialog(actionDataEntry, serverPlayer);
                break;
            }
            case OPEN_TRADING_SCREEN: {
                TradingDataCapable tradingData = this.getEasyNPCTradingData();
                if (tradingData != null) {
                    tradingData.openTradingScreen(serverPlayer);
                    break;
                }
                log.error("No trading data found for action {}", (Object)actionDataEntry);
                break;
            }
            default: {
                log.warn("Unknown action type {} for action {}", (Object)actionDataEntry.actionDataType(), (Object)actionDataEntry);
            }
        }
    }

    default public void openDefaultDialog(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        DialogDataCapable dialogData = this.getEasyNPCDialogData();
        if (dialogData != null) {
            dialogData.openDefaultDialog(serverPlayer);
        } else {
            log.error("No dialog data found for action {}", (Object)actionDataEntry);
            serverPlayer.closeContainer();
        }
    }

    default public void openNamedDialog(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        String dialogLabel = actionDataEntry.command();
        DialogDataCapable dialogData = this.getEasyNPCDialogData();
        if (dialogLabel != null && !dialogLabel.isEmpty() && dialogData != null && dialogData.hasDialog(dialogLabel)) {
            UUID dialogId = dialogData.getDialogId(dialogLabel);
            dialogData.openDialog(serverPlayer, dialogId);
        } else {
            log.error("Unknown dialog label {} for action {}", (Object)dialogLabel, (Object)actionDataEntry);
            serverPlayer.closeContainer();
        }
    }

    default public void executePlayerCommand(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        ActionEventDataCapable actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("No action event data found for action {}", (Object)actionDataEntry);
            return;
        }
        int userPermissionLevel = actionDataEntry.permissionLevel();
        if (userPermissionLevel > actionEventData.getActionPermissionLevel()) {
            log.warn("User permission level {} is lower than action permission level {} for action {}", (Object)actionEventData.getActionPermissionLevel(), (Object)userPermissionLevel, (Object)actionDataEntry);
            userPermissionLevel = actionEventData.getActionPermissionLevel();
        }
        log.debug("Try to execute action {} as user {} with user permission level {} of requested action permission level {} ...", (Object)actionDataEntry, (Object)serverPlayer, (Object)userPermissionLevel, (Object)actionDataEntry.permissionLevel());
        ActionHandler.executePlayerCommand(actionDataEntry.getAction(this.getLivingEntity(), serverPlayer), serverPlayer, userPermissionLevel, actionDataEntry.enableDebug());
    }

    default public void executeEntityCommand(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionHandler.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        ActionEventDataCapable actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("No action event data found for action {}", (Object)actionDataEntry);
            return;
        }
        int ownerPermissionLevel = actionEventData.getActionPermissionLevel();
        if (ownerPermissionLevel > 3) {
            ownerPermissionLevel = 3;
        } else if (ownerPermissionLevel <= 0) {
            ownerPermissionLevel = 1;
        }
        log.debug("Try to execute action {} as entity {} with owner permission level {} of max. {} ...", (Object)actionDataEntry, (Object)this.getEntity(), (Object)ownerPermissionLevel, (Object)actionEventData.getActionPermissionLevel());
        ActionHandler.executeEntityCommand(actionDataEntry.getAction(this.getLivingEntity(), serverPlayer), this.getEntity(), ownerPermissionLevel, actionDataEntry.enableDebug());
    }
}

