/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.manager;

import de.markusbordihn.easynpc.config.RenderEntityTypeSupportConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityTypeManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Entity Type Manager]";
    private static final Set<EntityType<? extends Entity>> unknownEntityTypes = new HashSet<EntityType<? extends Entity>>();
    private static final Set<EntityType<? extends Entity>> supportedEntityTypes = new HashSet<EntityType<? extends Entity>>();
    private static final Set<EntityType<? extends Entity>> unsupportedEntityTypes = new HashSet<EntityType<? extends Entity>>();
    private static final Map<EntityType<? extends Entity>, PathfinderMob> pathfinderMobMap = new ConcurrentHashMap<EntityType<? extends Entity>, PathfinderMob>();
    private static final Map<EntityType<? extends Entity>, Float> scaleFactorMap = new ConcurrentHashMap<EntityType<? extends Entity>, Float>();
    private static final Map<EntityType<? extends Entity>, String> entityTypeNameMap = new ConcurrentHashMap<EntityType<? extends Entity>, String>();

    private EntityTypeManager() {
    }

    public static void register() {
        log.info("{} Register Entity Type Manager ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
            if (entityType == null) {
                return;
            }
            String entityTypeLocation = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString();
            if (entityTypeLocation.startsWith("easy_npc") || entityTypeLocation.startsWith("mythicmounts:") || entityTypeLocation.endsWith("_arrow") || entityTypeLocation.endsWith("_projectile") || entityTypeLocation.endsWith("_thrown") || entityTypeLocation.endsWith("_ball") || entityTypeLocation.endsWith("_bullet") || entityTypeLocation.endsWith("_fireball") || entityTypeLocation.endsWith("_boat") || entityTypeLocation.endsWith("_part") || entityTypeLocation.endsWith("effect") || entityTypeLocation.contains(":projectile") || entityTypeLocation.contains("_attack") || entityTypeLocation.contains("multi_part") || entityTypeLocation.contains("effect_") || entityTypeLocation.contains("flash_") || entityTypeLocation.contains(":spell_")) {
                return;
            }
            entityTypeNameMap.put((EntityType<? extends Entity>)entityType, entityTypeLocation);
            if (RenderEntityTypeSupportConfig.isSupportedEntityType(entityTypeLocation)) {
                EntityTypeManager.addSupportedEntityType(entityType);
            } else if (RenderEntityTypeSupportConfig.isUnsupportedEntityType(entityTypeLocation)) {
                EntityTypeManager.addUnsupportedEntityType(entityType);
            } else {
                EntityTypeManager.addUnknownEntityType(entityType);
            }
        });
        log.info("[Entity Type Manager] Found {} supported, {} unsupported and {} unknown entity types.", (Object)supportedEntityTypes.size(), (Object)unsupportedEntityTypes.size(), (Object)unknownEntityTypes.size());
    }

    public static void addSupportedEntityType(EntityType<?> entityType) {
        supportedEntityTypes.add(entityType);
        unsupportedEntityTypes.remove(entityType);
        unknownEntityTypes.remove(entityType);
        scaleFactorMap.computeIfAbsent(entityType, EntityTypeManager::calculateScaleFactor);
    }

    public static void addUnsupportedEntityType(EntityType<?> entityType) {
        unsupportedEntityTypes.add(entityType);
        supportedEntityTypes.remove(entityType);
        unknownEntityTypes.remove(entityType);
        scaleFactorMap.remove(entityType);
    }

    public static void addUnknownEntityType(EntityType<?> entityType) {
        unknownEntityTypes.add(entityType);
        supportedEntityTypes.remove(entityType);
        unsupportedEntityTypes.remove(entityType);
        scaleFactorMap.computeIfAbsent(entityType, EntityTypeManager::calculateScaleFactor);
    }

    public static boolean isSupportedEntityType(EntityType<?> entityType) {
        return supportedEntityTypes.contains(entityType);
    }

    public static boolean isUnsupportedEntityType(EntityType<?> entityType) {
        return unsupportedEntityTypes.contains(entityType);
    }

    public static Set<EntityType<? extends Entity>> getUnknownEntityTypes() {
        return unknownEntityTypes;
    }

    public static Set<EntityType<? extends Entity>> getSupportedEntityTypes() {
        return supportedEntityTypes;
    }

    public static Set<EntityType<? extends Entity>> getUnsupportedEntityTypes() {
        return unsupportedEntityTypes;
    }

    public static List<EntityType<? extends Entity>> getUnknownAndSupportedEntityTypes() {
        ArrayList<EntityType<? extends Entity>> arrayList = new ArrayList<EntityType<? extends Entity>>();
        arrayList.addAll(supportedEntityTypes);
        arrayList.addAll(unknownEntityTypes);
        return arrayList;
    }

    public static float calculateScaleFactor(EntityType<? extends Entity> entityType) {
        EntityDimensions entityDimensions = entityType.getDimensions();
        float scaleFactor = 1.0f;
        float defaultWidth = 0.8f;
        float defaultHeight = 2.0f;
        float width = entityDimensions.width();
        float height = entityDimensions.height();
        if (width > defaultWidth || height > defaultHeight) {
            scaleFactor = Math.max(width / defaultWidth, height / defaultHeight);
        }
        return scaleFactor;
    }

    public static void updateUnknownEntityType(Level level) {
        if (unknownEntityTypes.isEmpty()) {
            return;
        }
        EntityType<? extends Entity> entityType = unknownEntityTypes.iterator().next();
        if (entityType != null) {
            EntityTypeManager.checkEntityType(entityType, level);
        }
    }

    public static boolean checkEntityType(EntityType<?> entityType, Level level) {
        return EntityTypeManager.getPathfinderMob(entityType, level) != null;
    }

    public static PathfinderMob getPathfinderMob(EntityType<?> entityType, Level level) {
        if (entityType == null) {
            return null;
        }
        PathfinderMob pathfinderMob = pathfinderMobMap.get(entityType);
        if (pathfinderMob != null) {
            if (pathfinderMob.isAlive()) {
                if (pathfinderMob.level() != level) {
                    try {
                        Field levelField = Entity.class.getDeclaredField("level");
                        levelField.setAccessible(true);
                        levelField.set(pathfinderMob, level);
                    }
                    catch (Exception e) {
                        log.error("{} Failed to update level for PathfinderMob {}", (Object)LOG_PREFIX, (Object)pathfinderMob);
                    }
                }
                return pathfinderMob;
            }
            log.debug("{} PathfinderMob {} is removed, re-creating it.", (Object)LOG_PREFIX, (Object)pathfinderMob);
            pathfinderMobMap.remove(entityType);
        }
        if (!EntityTypeManager.isUnsupportedEntityType(entityType)) {
            Entity entity = entityType.create(level);
            if (entity instanceof PathfinderMob) {
                PathfinderMob newPathfinderMob = (PathfinderMob)entity;
                log.debug("{} Registering PathfinderMob {} for {}", (Object)LOG_PREFIX, (Object)newPathfinderMob, entityType);
                newPathfinderMob.setNoAi(true);
                newPathfinderMob.setSilent(true);
                newPathfinderMob.noPhysics = true;
                pathfinderMobMap.put(entityType, newPathfinderMob);
                if (!EntityTypeManager.isSupportedEntityType(entityType)) {
                    EntityTypeManager.addSupportedEntityType(entityType);
                }
                return newPathfinderMob;
            }
            log.error("{} Invalid Entity type {} is not extending PathfinderMob!", (Object)LOG_PREFIX, entityType);
            if (entity != null) {
                entity.discard();
            }
            EntityTypeManager.addUnsupportedEntityType(entityType);
        }
        return null;
    }

    public static float getScaleFactor(EntityType<? extends Entity> entityType) {
        return scaleFactorMap.getOrDefault(entityType, Float.valueOf(1.0f)).floatValue();
    }

    public static String getEntityTypeName(EntityType<? extends Entity> entityType) {
        return entityTypeNameMap.getOrDefault(entityType, "Unknown");
    }
}

