/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.preset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.easynpc.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record PresetData(String name, EntityType<?> entityType, CompoundTag data) {
    public static final String ID = "preset_data";
    public static final String EMPTY_NAME = "Empty";
    public static final PresetData EMPTY = new PresetData("Empty", EntityType.ARMOR_STAND, new CompoundTag());
    public static final Codec<PresetData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(PresetData::name), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entityType").forGetter(PresetData::entityType), (App)CompoundTag.CODEC.fieldOf("data").forGetter(PresetData::data)).apply((Applicative)instance, PresetData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PresetData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PresetData::name, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), PresetData::entityType, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, PresetData::data, PresetData::new);

    public PresetData(EntityType<?> entityType, CompoundTag data) {
        this(entityType.getDescriptionId(), entityType, data);
    }

    public static boolean has(ItemStack itemStack) {
        return itemStack != null && !itemStack.isEmpty() && itemStack.has(DataComponents.PRESET_DATA) && !((PresetData)itemStack.getOrDefault(DataComponents.PRESET_DATA, (Object)EMPTY)).isEmpty();
    }

    public static PresetData get(ItemStack itemStack) {
        if (!PresetData.has(itemStack)) {
            return null;
        }
        return (PresetData)itemStack.get(DataComponents.PRESET_DATA);
    }

    public static ItemStack set(Item item, PresetData presetData) {
        return PresetData.set(new ItemStack((ItemLike)item), presetData);
    }

    public static ItemStack set(ItemStack itemStack, PresetData presetData) {
        if (itemStack == null || itemStack.isEmpty() || presetData == null) {
            return null;
        }
        itemStack.set(DataComponents.PRESET_DATA, (Object)presetData);
        return itemStack;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasEntityType() {
        return this.entityType != null;
    }
}

