/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.scale;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record CustomScale(float x, float y, float z) {
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomScale> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CustomScale>(){

        public CustomScale decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new CustomScale(registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, CustomScale scale) {
            registryFriendlyByteBuf.writeFloat(scale.x);
            registryFriendlyByteBuf.writeFloat(scale.y);
            registryFriendlyByteBuf.writeFloat(scale.z);
        }
    };

    public CustomScale(ModelPartType modelPartType, CompoundTag compoundTag) {
        this(compoundTag.getList(modelPartType.getTagName(), 5));
    }

    public CustomScale(ListTag listTag) {
        this(listTag.getFloat(0), listTag.getFloat(1), listTag.getFloat(2));
    }

    public CustomScale(List<Float> list) {
        this(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue());
    }

    public CustomScale(float scale) {
        this(scale, scale, scale);
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)this.x));
        listTag.add((Object)FloatTag.valueOf((float)this.y));
        listTag.add((Object)FloatTag.valueOf((float)this.z));
        return listTag;
    }

    public boolean hasChanged() {
        return this.hasChanged(1.0f, 1.0f, 1.0f);
    }

    public boolean hasChanged(float x, float y, float z) {
        return this.x != x || this.y != y || this.z != z;
    }
}

