/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;

public class CustomLookAtPlayerGoal<T extends EasyNPC<?>>
extends LookAtPlayerGoal {
    private final ModelDataCapable<?> modelData;

    public CustomLookAtPlayerGoal(T easyNPC, Class<? extends LivingEntity> lookAtType, float lookDistance, float probability) {
        this(easyNPC, lookAtType, lookDistance, probability, false);
    }

    public CustomLookAtPlayerGoal(T easyNPC, Class<? extends LivingEntity> lookAtType, float lookDistance, float probability, boolean onlyHorizontal) {
        super(easyNPC.getMob(), lookAtType, lookDistance, probability, onlyHorizontal);
        this.modelData = easyNPC.getEasyNPCModelData();
    }

    public boolean canUse() {
        return (this.modelData == null || !this.modelData.getModelPartRotation(ModelPartType.ROOT).locked()) && super.canUse();
    }

    public boolean canContinueToUse() {
        return (this.modelData == null || !this.modelData.getModelPartRotation(ModelPartType.ROOT).locked()) && super.canContinueToUse();
    }

    public void tick() {
        if (this.modelData == null || !this.modelData.getModelPartRotation(ModelPartType.ROOT).locked()) {
            super.tick();
        }
    }
}

