/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.validator;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UrlValidator {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String[] FORBIDDEN_EXTENSIONS = new String[]{".exe", ".msi", ".dmg", ".jar", ".bat", ".cmd", ".com", ".pif", ".scr", ".cpl", ".msc", ".jar", ".app", ".sh", ".vb", ".vbs", ".vbe", ".js", ".jse", ".ws", ".wsc", ".wsh", ".ps1", ".ps1xml", ".ps2", ".ps2xml", ".psc1", ".psc2", ".msh", ".msh1", ".msh2", ".mshxml", ".msh1xml", ".msh2xml", ".scf", ".lnk", ".inf", ".reg", ".dll", ".sys", ".drv", ".cpl", ".ocx", ".ax", ".spl", ".scr", ".mui", ".dmp", ".sys", ".cpl", ".ocx", ".ax", ".spl", ".scr", ".mui", ".dmp", ".msc", ".msp", ".msu", ".paf", ".zip", ".rar", ".7z", ".tar", ".gz", ".tgz"};
    private static final String[] SECURE_REMOTE_URLS = new String[]{"https://www.minecraftskins.com/", "https://minecraft.novaskin.me/", "https://mcskins.top/", "https://skinmc.net/"};

    private UrlValidator() {
    }

    public static boolean isSecureRemoteUrl(String url) {
        if (!UrlValidator.isValidUrl(url) || !url.startsWith("https://")) {
            return false;
        }
        for (String secureUrl : SECURE_REMOTE_URLS) {
            if (!url.startsWith(secureUrl)) continue;
            return true;
        }
        return true;
    }

    public static boolean isValidUrl(String url) {
        if (url == null || url.isEmpty() || !url.startsWith("http://") && !url.startsWith("https://")) {
            if (url != null && !url.isEmpty()) {
                log.error("Invalid URL: {}", (Object)url);
            }
            return false;
        }
        for (String extension : FORBIDDEN_EXTENSIONS) {
            if (!url.endsWith(extension)) continue;
            log.error("Forbidden extension found in URL: {}", (Object)url);
            return false;
        }
        try {
            new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("Invalid URL format: {}", (Object)url);
            return false;
        }
        return true;
    }
}

