/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.CustomButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class SpinButton<T>
extends CustomButton {
    private final TextButton previousButton;
    private final TextButton nextButton;
    private final TextButton textButton;
    private final List<T> values;
    private final OnChange onChange;
    private int currentIndex;

    public SpinButton(int x, int y, int width, int height, Set<T> values, T initialValue, OnChange onChange) {
        super(x, y, width, height);
        this.values = new ArrayList<T>(values);
        this.currentIndex = Math.max(0, this.values.indexOf(initialValue));
        this.onChange = onChange;
        int navWidth = 10;
        this.previousButton = new TextButton(x, y, navWidth, height, "<", this::previous);
        this.textButton = new TextButton(x + navWidth, y, width - 2 * navWidth, height, "", this::next);
        this.nextButton = new TextButton(x + width - navWidth, y, navWidth, height, ">", this::next);
        this.updateButtonStates();
    }

    private void previous(Button button) {
        if (this.currentIndex > 0) {
            this.setIndex(this.currentIndex - 1);
        }
    }

    private void next(Button button) {
        if (this.currentIndex < this.values.size() - 1) {
            this.setIndex(this.currentIndex + 1);
        } else if (button == this.textButton && !this.values.isEmpty()) {
            this.setIndex(0);
        }
    }

    private void setIndex(int index) {
        this.currentIndex = index;
        this.updateButtonStates();
        if (this.onChange != null) {
            this.onChange.onChange(this);
        }
    }

    private void updateButtonStates() {
        boolean hasValues = !this.values.isEmpty();
        this.previousButton.f_93623_ = hasValues && this.currentIndex > 0;
        this.nextButton.f_93623_ = hasValues && this.currentIndex < this.values.size() - 1;
        this.textButton.f_93623_ = hasValues;
    }

    public T get() {
        return this.values.isEmpty() ? null : (T)this.values.get(this.currentIndex);
    }

    @Override
    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        this.previousButton.renderButton(guiGraphics, left, top, partialTicks);
        this.nextButton.renderButton(guiGraphics, left, top, partialTicks);
        this.textButton.renderButton(guiGraphics, left, top, partialTicks);
        T value = this.get();
        if (value != null) {
            this.textButton.m_93666_((Component)TextComponent.getText(value.toString()));
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.previousButton.m_6375_(mouseX, mouseY, button) || this.nextButton.m_6375_(mouseX, mouseY, button) || this.textButton.m_6375_(mouseX, mouseY, button);
    }

    public static interface OnChange {
        public void onChange(SpinButton<?> var1);
    }
}

