/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ActionEventSet {
    public static final String DATA_ACTION_EVENT_SET_TAG = "ActionEventSet";
    private final EnumMap<ActionEventType, ActionDataSet> actionsMap = new EnumMap(ActionEventType.class);
    private boolean hasDistanceActionEvent = false;

    public ActionEventSet() {
    }

    public ActionEventSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public void setActionEvent(ActionEventType actionEventType, ActionDataSet actionDataSet) {
        if (actionEventType != null && actionEventType != ActionEventType.NONE && actionDataSet != null) {
            this.actionsMap.put(actionEventType, actionDataSet);
            this.updateHasDistanceAction();
        }
    }

    public ActionDataEntry getActionEvent(ActionEventType actionEventType) {
        ActionDataSet actionDataSet;
        if (actionEventType != null && actionEventType != ActionEventType.NONE && (actionDataSet = this.actionsMap.get((Object)actionEventType)) != null && !actionDataSet.isEmpty()) {
            return actionDataSet.getRandomEntry();
        }
        return null;
    }

    public ActionDataSet getActionEvents(ActionEventType actionEventType) {
        if (actionEventType != ActionEventType.NONE && this.actionsMap.containsKey((Object)actionEventType)) {
            return this.actionsMap.get((Object)actionEventType);
        }
        return new ActionDataSet();
    }

    public boolean hasActionEvent(ActionEventType actionEventType) {
        if (actionEventType != null && actionEventType != ActionEventType.NONE) {
            ActionDataSet actions = this.actionsMap.get((Object)actionEventType);
            return actions != null && !actions.isEmpty();
        }
        return false;
    }

    public void updateHasDistanceAction() {
        this.hasDistanceActionEvent = this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_NEAR) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_NEAR).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_CLOSE) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_CLOSE).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_VERY_CLOSE) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_VERY_CLOSE).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_TOUCH) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_TOUCH).isEmpty();
    }

    public void clear() {
        this.actionsMap.clear();
        this.hasDistanceActionEvent = false;
    }

    public void load(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_ACTION_EVENT_SET_TAG)) {
            return;
        }
        this.clear();
        CompoundTag actionDataSetTag = compoundTag.m_128469_(DATA_ACTION_EVENT_SET_TAG);
        for (ActionEventType actionEventType : ActionEventType.values()) {
            ActionDataSet actionDataEntryList = new ActionDataSet(actionDataSetTag, actionEventType.name());
            if (actionDataEntryList.isEmpty()) continue;
            this.actionsMap.put(actionEventType, actionDataEntryList);
        }
        this.updateHasDistanceAction();
    }

    public CompoundTag save(CompoundTag compoundTag) {
        CompoundTag actionsTag = new CompoundTag();
        for (Map.Entry<ActionEventType, ActionDataSet> entry : this.actionsMap.entrySet()) {
            ActionEventType actionEventType = entry.getKey();
            ActionDataSet actionDataSet = entry.getValue();
            actionDataSet.save(actionsTag, actionEventType.name());
        }
        compoundTag.m_128365_(DATA_ACTION_EVENT_SET_TAG, (Tag)actionsTag);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public String toString() {
        return "ActionEventSet [ hasDistanceActionEvent=" + this.hasDistanceActionEvent + ", " + String.valueOf(this.actionsMap) + "]";
    }
}

