/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;

public class ActionUtils {
    public static final String COMMAND_DISPLAY_TITLE = "/title @initiator title {\"text\":\"";
    public static final String MACRO_ERROR_MESSAGE = "/error_message";
    public static final String MACRO_INFO_MESSAGE = "/info_message";
    public static final String MACRO_INITIATOR = "@initiator";
    public static final String MACRO_INITIATOR_UUID = "@initiator-uuid";
    public static final String MACRO_NPC = "@npc";
    public static final String MACRO_NPC_UUID = "@npc-uuid";
    public static final String MACRO_SUCCESS_MESSAGE = "/success_message";
    public static final String MACRO_WARN_MESSAGE = "/warn_message";
    private static final Pattern SCORE_PATTERN = Pattern.compile("@score\\(([a-zA-Z0-9_.-]+)\\)");

    private ActionUtils() {
    }

    public static String parseAction(String command, LivingEntity entity, ServerPlayer player) {
        if (command == null || ((String)command).isEmpty()) {
            return "";
        }
        Object output = command;
        if (!((String)command).startsWith("/")) {
            command = "/" + (String)command;
        }
        if (((String)command).startsWith(MACRO_ERROR_MESSAGE)) {
            output = ((String)output).replace(MACRO_ERROR_MESSAGE, "").trim();
            output = COMMAND_DISPLAY_TITLE + ActionUtils.escapeJson((String)output) + "\",\"color\":\"dark_red\"}";
        } else if (((String)command).startsWith(MACRO_WARN_MESSAGE)) {
            output = ((String)output).replace(MACRO_WARN_MESSAGE, "").trim();
            output = COMMAND_DISPLAY_TITLE + ActionUtils.escapeJson((String)output) + "\",\"color\":\"yellow\"}";
        } else if (((String)command).startsWith(MACRO_INFO_MESSAGE)) {
            output = ((String)output).replace(MACRO_INFO_MESSAGE, "").trim();
            output = COMMAND_DISPLAY_TITLE + ActionUtils.escapeJson((String)output) + "\",\"color\":\"aqua\"}";
        } else if (((String)command).startsWith(MACRO_SUCCESS_MESSAGE)) {
            output = ((String)output).replace(MACRO_SUCCESS_MESSAGE, "").trim();
            output = COMMAND_DISPLAY_TITLE + ActionUtils.escapeJson((String)output) + "\",\"color\":\"green\"}";
        }
        if (entity != null) {
            output = ((String)output).replace(MACRO_NPC_UUID, entity.m_20148_().toString());
            output = ((String)output).replace(MACRO_NPC, entity.m_7755_().getString());
        }
        if (player != null) {
            output = ((String)output).replace(MACRO_INITIATOR_UUID, player.m_20148_().toString());
            output = ((String)output).replace(MACRO_INITIATOR, player.m_7755_().getString());
            Matcher matcher = SCORE_PATTERN.matcher((CharSequence)output);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                String objectiveName = matcher.group(1);
                int score = ActionUtils.getScoreboardValue(player, objectiveName);
                matcher.appendReplacement(sb, Matcher.quoteReplacement(String.valueOf(score)));
            }
            matcher.appendTail(sb);
            output = sb.toString();
        }
        return output;
    }

    private static int getScoreboardValue(ServerPlayer player, String objectiveName) {
        if (objectiveName == null || objectiveName.isEmpty() || objectiveName.length() > 16) {
            return 0;
        }
        Scoreboard scoreboard = player.m_36329_();
        Objective objective = scoreboard.m_83477_(objectiveName);
        if (objective != null && scoreboard.m_83461_(player.m_6302_(), objective)) {
            return scoreboard.m_83471_(player.m_6302_(), objective).m_83400_();
        }
        return 0;
    }

    private static String escapeJson(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }
}

