/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

public enum ConditionOperationType {
    NONE,
    EQUALS,
    NOT_EQUALS,
    GREATER_THAN,
    GREATER_THAN_OR_EQUALS,
    LESS_THAN,
    LESS_THAN_OR_EQUALS;


    public static ConditionOperationType get(String operationType) {
        if (operationType == null || operationType.isEmpty()) {
            return NONE;
        }
        try {
            return ConditionOperationType.valueOf(operationType);
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }

    public String getSymbol() {
        return switch (this) {
            case EQUALS -> "==";
            case NOT_EQUALS -> "!=";
            case GREATER_THAN -> ">";
            case GREATER_THAN_OR_EQUALS -> ">=";
            case LESS_THAN -> "<";
            case LESS_THAN_OR_EQUALS -> "<=";
            default -> "";
        };
    }

    public boolean evaluate(int value1, int value2) {
        return switch (this) {
            case EQUALS -> {
                if (value1 == value2) {
                    yield true;
                }
                yield false;
            }
            case NOT_EQUALS -> {
                if (value1 != value2) {
                    yield true;
                }
                yield false;
            }
            case GREATER_THAN -> {
                if (value1 > value2) {
                    yield true;
                }
                yield false;
            }
            case GREATER_THAN_OR_EQUALS -> {
                if (value1 >= value2) {
                    yield true;
                }
                yield false;
            }
            case LESS_THAN -> {
                if (value1 < value2) {
                    yield true;
                }
                yield false;
            }
            case LESS_THAN_OR_EQUALS -> {
                if (value1 <= value2) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

