/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConditionUtils {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ConditionUtils() {
    }

    public static boolean evaluateCondition(ConditionDataEntry conditionDataEntry, ServerPlayer player) {
        if (conditionDataEntry == null || !conditionDataEntry.isValid() || player == null) {
            return false;
        }
        return switch (conditionDataEntry.conditionType()) {
            default -> throw new IncompatibleClassChangeError();
            case ConditionType.SCOREBOARD -> ConditionUtils.evaluateScoreboardCondition(conditionDataEntry, player);
            case ConditionType.NONE -> true;
        };
    }

    public static boolean evaluateConditions(Set<ConditionDataEntry> conditions, ServerPlayer player) {
        if (conditions == null || conditions.isEmpty() || player == null) {
            return true;
        }
        for (ConditionDataEntry condition : conditions) {
            if (ConditionUtils.evaluateCondition(condition, player)) continue;
            log.debug("Condition not met: {}", (Object)condition);
            return false;
        }
        return true;
    }

    public static boolean evaluateScoreboardCondition(ConditionDataEntry conditionDataEntry, ServerPlayer serverPlayer) {
        if (!conditionDataEntry.hasName() || serverPlayer == null) {
            return false;
        }
        try {
            Scoreboard scoreboard = serverPlayer.m_36329_();
            Objective objective = scoreboard.m_83477_(conditionDataEntry.name());
            if (objective == null) {
                log.debug("Scoreboard objective '{}' not found for player {}", (Object)conditionDataEntry.name(), (Object)serverPlayer.m_7755_().getString());
                return false;
            }
            Score score = scoreboard.m_83471_(serverPlayer.m_6302_(), objective);
            int scoreValue = score.m_83400_();
            int targetValue = conditionDataEntry.value();
            boolean result = conditionDataEntry.operationType().evaluate(scoreValue, targetValue);
            log.debug("Scoreboard evaluation: {} {} {} = {} (actual: {})", (Object)conditionDataEntry.name(), (Object)conditionDataEntry.operationType().getSymbol(), (Object)targetValue, (Object)result, (Object)scoreValue);
            return result;
        }
        catch (Exception e) {
            log.error("Error evaluating scoreboard condition: {}", (Object)conditionDataEntry, (Object)e);
            return false;
        }
    }
}

