/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.screen;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.attribute.BaseAttributes;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.scoreboard.ScoreboardData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class AdditionalScreenData {
    private static final String ACTION_EVENT_DATA_TAG = "ActionEventData";
    private static final String ACTION_EVENT_TYPE_TAG = "ActionEventType";
    private static final String BASE_ATTRIBUTES_DATA_TAG = "BaseAttributesData";
    private static final String CONFIGURATION_TYPE_TAG = "ConfigurationType";
    private static final String DIALOG_DATA_TAG = "DialogData";
    private static final String EDITOR_TYPE_TAG = "EditorType";
    private static final String OBJECTIVE_DATA_TAG = "ObjectiveData";
    private static final String SCOREBOARD_DATA_TAG = "ScoreboardData";
    private final ActionEventSet actionEventSet;
    private final ActionEventType actionEventType;
    private final BaseAttributes baseAttributes;
    private final CompoundTag data;
    private final ConfigurationType configurationType;
    private final DialogDataSet dialogDataSet;
    private final EditorType editorType;
    private final ObjectiveDataSet objectiveDataSet;
    private final ScoreboardData scoreboardData;

    public AdditionalScreenData(CompoundTag compoundTag) {
        this.actionEventSet = AdditionalScreenData.getActionEventSet(compoundTag);
        this.actionEventType = AdditionalScreenData.getActionEventType(compoundTag);
        this.baseAttributes = AdditionalScreenData.getBaseAttributes(compoundTag);
        this.configurationType = AdditionalScreenData.getConfigurationType(compoundTag);
        this.dialogDataSet = AdditionalScreenData.getDialogDataSet(compoundTag);
        this.editorType = AdditionalScreenData.getEditorType(compoundTag);
        this.objectiveDataSet = AdditionalScreenData.getObjectiveDataSet(compoundTag);
        this.scoreboardData = AdditionalScreenData.getScoreboardData(compoundTag);
        this.data = compoundTag;
        this.data.m_128473_(ACTION_EVENT_DATA_TAG);
        this.data.m_128473_(ACTION_EVENT_TYPE_TAG);
        this.data.m_128473_(BASE_ATTRIBUTES_DATA_TAG);
        this.data.m_128473_(CONFIGURATION_TYPE_TAG);
        this.data.m_128473_(DIALOG_DATA_TAG);
        this.data.m_128473_(EDITOR_TYPE_TAG);
        this.data.m_128473_(OBJECTIVE_DATA_TAG);
        this.data.m_128473_(SCOREBOARD_DATA_TAG);
    }

    public static void addActionEventType(CompoundTag compoundTag, ActionEventType actionEventType) {
        if (compoundTag == null || actionEventType == null) {
            return;
        }
        compoundTag.m_128359_(ACTION_EVENT_TYPE_TAG, actionEventType.name());
    }

    public static ActionEventType getActionEventType(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasActionEventType(compoundTag)) {
            return ActionEventType.NONE;
        }
        return ActionEventType.get(compoundTag.m_128461_(ACTION_EVENT_TYPE_TAG));
    }

    public static boolean hasActionEventType(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.m_128441_(ACTION_EVENT_TYPE_TAG);
    }

    public static void addActionEventSet(CompoundTag compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCActionEventData() == null) {
            return;
        }
        compoundTag.m_128365_(ACTION_EVENT_DATA_TAG, (Tag)easyNPC.getEasyNPCActionEventData().getActionEventSet().createTag());
    }

    public static ActionEventSet getActionEventSet(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasActionEventSet(compoundTag)) {
            return new ActionEventSet();
        }
        return new ActionEventSet(compoundTag.m_128469_(ACTION_EVENT_DATA_TAG));
    }

    public static boolean hasActionEventSet(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.m_128441_(ACTION_EVENT_DATA_TAG);
    }

    public static void addBaseAttributes(CompoundTag compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        compoundTag.m_128365_(BASE_ATTRIBUTES_DATA_TAG, (Tag)new BaseAttributes(easyNPC.getLivingEntity()).createTag());
    }

    public static BaseAttributes getBaseAttributes(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasBaseAttributes(compoundTag)) {
            return new BaseAttributes();
        }
        return new BaseAttributes(compoundTag.m_128469_(BASE_ATTRIBUTES_DATA_TAG));
    }

    public static boolean hasBaseAttributes(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.m_128441_(BASE_ATTRIBUTES_DATA_TAG);
    }

    public static void addConfigurationType(CompoundTag compoundTag, ConfigurationType configurationType) {
        if (compoundTag == null || configurationType == null) {
            return;
        }
        compoundTag.m_128359_(CONFIGURATION_TYPE_TAG, configurationType.name());
    }

    public static ConfigurationType getConfigurationType(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasConfigurationType(compoundTag)) {
            return ConfigurationType.NONE;
        }
        return ConfigurationType.get(compoundTag.m_128461_(CONFIGURATION_TYPE_TAG));
    }

    public static boolean hasConfigurationType(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.m_128441_(CONFIGURATION_TYPE_TAG);
    }

    public static void addDialogDataSet(CompoundTag compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCDialogData() == null) {
            return;
        }
        compoundTag.m_128365_(DIALOG_DATA_TAG, (Tag)easyNPC.getEasyNPCDialogData().getDialogDataSet().createTag());
    }

    public static DialogDataSet getDialogDataSet(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasDialogDataSet(compoundTag)) {
            return new DialogDataSet();
        }
        return new DialogDataSet(compoundTag.m_128469_(DIALOG_DATA_TAG));
    }

    public static boolean hasDialogDataSet(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.m_128441_(DIALOG_DATA_TAG);
    }

    public static void addEditorType(CompoundTag compoundTag, EditorType editorType) {
        if (compoundTag == null || editorType == null) {
            return;
        }
        compoundTag.m_128359_(EDITOR_TYPE_TAG, editorType.name());
    }

    public static EditorType getEditorType(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasEditorType(compoundTag)) {
            return EditorType.NONE;
        }
        return EditorType.get(compoundTag.m_128461_(EDITOR_TYPE_TAG));
    }

    public static boolean hasEditorType(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.m_128441_(EDITOR_TYPE_TAG);
    }

    public static void addObjectiveDataSet(CompoundTag compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCObjectiveData() == null) {
            return;
        }
        compoundTag.m_128365_(OBJECTIVE_DATA_TAG, (Tag)easyNPC.getEasyNPCObjectiveData().getObjectiveDataSet().createTag());
    }

    public static ObjectiveDataSet getObjectiveDataSet(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasObjectiveDataSet(compoundTag)) {
            return new ObjectiveDataSet();
        }
        return new ObjectiveDataSet(compoundTag.m_128469_(OBJECTIVE_DATA_TAG));
    }

    public static boolean hasObjectiveDataSet(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.m_128441_(OBJECTIVE_DATA_TAG);
    }

    public static void addScoreboardData(CompoundTag compoundTag, ScoreboardData scoreboardData) {
        if (compoundTag == null || scoreboardData == null) {
            return;
        }
        compoundTag.m_128365_(SCOREBOARD_DATA_TAG, (Tag)scoreboardData.createTag());
    }

    public static ScoreboardData getScoreboardData(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasScoreboardData(compoundTag)) {
            return new ScoreboardData();
        }
        return new ScoreboardData(compoundTag.m_128469_(SCOREBOARD_DATA_TAG));
    }

    public static boolean hasScoreboardData(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.m_128441_(SCOREBOARD_DATA_TAG);
    }

    public static void addDialogDataSet(CompoundTag compoundTag, EasyNPC<?> easyNPC, ServerPlayer serverPlayer) {
        Set<String> objectiveNames;
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCDialogData() == null) {
            return;
        }
        DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
        compoundTag.m_128365_(DIALOG_DATA_TAG, (Tag)dialogDataSet.createTag());
        if (serverPlayer != null && !(objectiveNames = AdditionalScreenData.extractObjectiveNamesFromDialogDataSet(dialogDataSet)).isEmpty()) {
            ScoreboardData scoreboardData = new ScoreboardData(serverPlayer, objectiveNames);
            AdditionalScreenData.addScoreboardData(compoundTag, scoreboardData);
        }
    }

    private static Set<String> extractObjectiveNamesFromDialogDataSet(DialogDataSet dialogDataSet) {
        HashSet<String> objectiveNames = new HashSet<String>();
        if (dialogDataSet == null || !dialogDataSet.hasDialog()) {
            return objectiveNames;
        }
        for (DialogDataEntry dialogEntry : dialogDataSet.getDialogsByLabel()) {
            if (dialogEntry == null || dialogEntry.getDialogTexts() == null) continue;
            for (DialogTextData dialogTextData : dialogEntry.getDialogTexts()) {
                if (dialogTextData == null || dialogTextData.text() == null) continue;
                objectiveNames.addAll(ScoreboardData.parseScoreMacros(dialogTextData.text()));
            }
        }
        return objectiveNames;
    }

    public ActionEventType getActionEventType() {
        return this.actionEventType;
    }

    public ActionEventSet getActionEventSet() {
        return this.actionEventSet;
    }

    public BaseAttributes getBaseAttributes() {
        return this.baseAttributes;
    }

    public ConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    public DialogDataSet getDialogDataSet() {
        return this.dialogDataSet;
    }

    public EditorType getEditorType() {
        return this.editorType;
    }

    public ObjectiveDataSet getObjectiveDataSet() {
        return this.objectiveDataSet;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public CompoundTag get(String dataTag) {
        if (this.data.m_128441_(dataTag)) {
            return this.data.m_128469_(dataTag);
        }
        return new CompoundTag();
    }

    public ListTag getList(String dataTag) {
        if (this.data.m_128441_(dataTag)) {
            return this.data.m_128437_(dataTag, 10);
        }
        return new ListTag();
    }

    public boolean hasDialogDataSet() {
        return this.dialogDataSet != null;
    }

    public ScoreboardData getScoreboardData() {
        return this.scoreboardData;
    }
}

