/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.entity.ModEntityTypeProvider;
import de.markusbordihn.easynpc.entity.NPCEntityFactory;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDefinedEntityType
implements ModEntityTypeProvider {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final String entityId;
    private final EntityType<?> baseEntityType;
    private final EntityType.Builder<? extends Entity> entityBuilder;
    private final ResourceKey<EntityType<?>> resourceKey;

    public UserDefinedEntityType(String entityId, EntityType<?> baseEntityType, float width, float height) {
        this.entityId = entityId;
        this.baseEntityType = baseEntityType;
        this.entityBuilder = this.createEntityBuilder(width, height);
        this.resourceKey = this.createResourceKey(entityId);
    }

    @Override
    public String getId() {
        return this.entityId;
    }

    @Override
    public EntityType.Builder<? extends Entity> getBuilder() {
        return this.entityBuilder;
    }

    @Override
    public ResourceKey<EntityType<?>> getResourceKey() {
        return this.resourceKey;
    }

    public EntityType<?> getBaseEntityType() {
        return this.baseEntityType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UserDefinedEntityType)) {
            return false;
        }
        UserDefinedEntityType that = (UserDefinedEntityType)other;
        return this.entityId.equals(that.entityId);
    }

    public int hashCode() {
        return this.entityId.hashCode();
    }

    public String toString() {
        return "UserDefinedEntityType{entityId='" + this.entityId + "', baseEntityType='" + String.valueOf(this.baseEntityType) + "'}";
    }

    private EntityType.Builder<? extends Entity> createEntityBuilder(float width, float height) {
        return EntityType.Builder.m_20704_((entityType, level) -> {
            try {
                return NPCEntityFactory.createEntityFromBaseType(this.baseEntityType, entityType, level);
            }
            catch (Exception e) {
                log.error("Failed to create entity of type {} based on {}: {}", (Object)this.entityId, this.baseEntityType, (Object)e.getMessage(), (Object)e);
                return null;
            }
        }, (MobCategory)MobCategory.MISC).m_20699_(width, height).m_20702_(12);
    }

    private ResourceKey<EntityType<?>> createResourceKey(String entityId) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("easy_npc_custom", entityId));
    }
}

